/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.io;

import io.lumine.artifacts.Artifacts;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyConfiguration;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.util.HashSet;
import java.util.List;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager
extends PropertyConfiguration<Artifacts> {
    private IOLoader<Artifacts> settingsLoader;
    private IOLoader<Artifacts> reagentsLoader;
    private List<IOLoader<Artifacts>> saveSkillList;
    private MythicConfig config;
    private int clockInterval = 1;
    public static int debugLevel = -1;
    public static boolean debugMode = false;
    public static boolean errorLogging = true;
    public static boolean AllowMetrics = true;
    public static boolean AllowUpdateChecking = true;
    private Boolean useEnchantments = true;
    private Boolean useItemLoreStats = false;
    private boolean moduleClassAttributes = false;
    public static boolean restrictLeather = false;
    public static boolean restrictChain = true;
    public static boolean restrictGold = true;
    public static boolean restrictIron = true;
    public static boolean restrictDiamond = true;
    public static boolean STAT_ENABLED_ABILITYPOWER = true;
    public static boolean STAT_ENABLED_ARMOR = true;
    public static boolean STAT_ENABLED_CRITICALSTRIKE = true;
    public static boolean STAT_ENABLED_DODGE = true;
    public static boolean STAT_ENABLED_DURABILITY = true;
    public static boolean STAT_ENABLED_LEECH = true;
    public static boolean STAT_ENABLED_SPEED = true;
    public static String AbilityPowerKeyword = "Ability Power";
    public static String ArmorKeyword = "Armor";
    public static String CriticalStrikeKeyword = "Critical Strike";
    public static String DodgeKeyword = "Dodge";
    public static String LeechKeyword = "Leech";
    public static String SpeedKeyword = "Speed";
    private HashSet<Byte> TransparentBlocks;
    private boolean requireClassUnlocks = false;
    private boolean perClassLevels = true;

    public ConfigManager(Artifacts plugin) {
        super((LuminePlugin)plugin);
    }

    public void load() {
        this.settingsLoader = new IOLoader((JavaPlugin)Artifacts.inst(), "config.yml");
        this.loadSettings();
    }

    public void unload() {
    }

    public void loadSettings() {
        Artifacts.debug(1, "* Checking for Settings...");
        if (!this.settingsLoader.getCustomConfig().contains("Configuration.Version")) {
            return;
        }
        Artifacts.debug(1, "** Loading Settings...");
        this.config = new MythicConfig("Configuration", this.settingsLoader.getCustomConfig());
        AllowMetrics = this.config.getBoolean("General.AllowMetrics", true);
        if (debugLevel == -1) {
            debugLevel = this.config.getInt("General.DebugLevel", 0);
        }
        errorLogging = this.config.getBoolean("General.ErrorLogging", true);
        AllowUpdateChecking = this.config.getBoolean("General.CheckForUpdates", true);
        this.useEnchantments = this.config.getBoolean("Enchantments.Enabled", true);
        this.useItemLoreStats = this.config.getBoolean("LoreStats.Enabled", false);
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public IOLoader<Artifacts> getReagentFile() {
        return this.reagentsLoader;
    }

    public List<IOLoader<Artifacts>> getSkillFiles() {
        return this.saveSkillList;
    }

    public int getDebugLevel() {
        return debugLevel;
    }

    public int getClockInterval() {
        return this.clockInterval;
    }

    public Boolean getUseEnchantments() {
        return this.useEnchantments;
    }

    public Boolean getUseItemLoreStats() {
        return this.useItemLoreStats;
    }
}

