/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.items;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.io.ConfigManager;
import io.lumine.artifacts.items.ItemManager;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DurabilityManager {
    private static final String KEY_DURABILITY = "Durability";
    private static final String KEY_MAXDURABILITY = "MaxDurability";

    public static void handleDurabilityHand(Player player) {
        ItemStack item = player.getEquipment().getItemInHand();
        DurabilityManager.tickDurability(player, item);
    }

    public static void tickDurability(Player player, ItemStack item) {
        if (!ConfigManager.STAT_ENABLED_DURABILITY) {
            return;
        }
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasLore()) {
            ItemMeta im = item.getItemMeta();
            ArrayList<String> newLore = new ArrayList<String>();
            for (String lore : item.getItemMeta().getLore()) {
                Matcher valueMatcher = ItemManager.DurabilityRegex.matcher(lore);
                if (valueMatcher.find()) {
                    int d = Integer.valueOf(valueMatcher.group(1));
                    int dM = Integer.valueOf(valueMatcher.group(2));
                    if (--d <= 0) {
                        player.getInventory().remove(item);
                        Schedulers.sync().runLater(() -> Artifacts.inst().getProfileManager().getPlayerProfile(player).parseWeapons(), 1L);
                        break;
                    }
                    lore = valueMatcher.replaceAll("Durability " + d + " / " + dM);
                    if (!im.spigot().isUnbreakable() && item.getType().getMaxDurability() > 0) {
                        double p = 1.0 - (double)d / (double)dM;
                        double dN = p * (double)(item.getType().getMaxDurability() - 1);
                        item.setDurability((short)dN);
                    }
                }
                newLore.add(lore);
            }
            im.setLore(newLore);
            item.setItemMeta(im);
        }
    }

    public static void handleDurabilityArmor(Player player) {
        if (!ConfigManager.STAT_ENABLED_DURABILITY) {
            return;
        }
        for (int i = 1; i <= 4; ++i) {
            ItemStack item;
            switch (i) {
                case 1: {
                    item = player.getEquipment().getBoots();
                    break;
                }
                case 2: {
                    item = player.getEquipment().getLeggings();
                    break;
                }
                case 3: {
                    item = player.getEquipment().getChestplate();
                    break;
                }
                case 4: {
                    item = player.getEquipment().getHelmet();
                    break;
                }
                default: {
                    item = null;
                }
            }
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
            ItemMeta im = item.getItemMeta();
            ArrayList<String> newLore = new ArrayList<String>();
            for (String lore : item.getItemMeta().getLore()) {
                Matcher valueMatcher = ItemManager.DurabilityRegex.matcher(lore);
                if (valueMatcher.find()) {
                    int d = Integer.valueOf(valueMatcher.group(1));
                    int dM = Integer.valueOf(valueMatcher.group(2));
                    if (--d <= 0) {
                        switch (i) {
                            case 1: {
                                player.getInventory().setBoots(null);
                                break;
                            }
                            case 2: {
                                player.getInventory().setLeggings(null);
                                break;
                            }
                            case 3: {
                                player.getInventory().setChestplate(null);
                                break;
                            }
                            case 4: {
                                player.getInventory().setHelmet(null);
                            }
                        }
                        break;
                    }
                    lore = valueMatcher.replaceAll("Durability " + d + " / " + dM);
                    if (!im.spigot().isUnbreakable() && item.getType().getMaxDurability() > 0) {
                        double p = 1.0 - (double)d / (double)dM;
                        double dN = p * (double)(item.getType().getMaxDurability() - 1);
                        item.setDurability((short)dN);
                    }
                }
                newLore.add(lore);
            }
            im.setLore(newLore);
            item.setItemMeta(im);
        }
    }

    public static boolean handleItemBreak(ItemStack item) {
        if (!ConfigManager.STAT_ENABLED_DURABILITY) {
            return false;
        }
        boolean found = false;
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasLore()) {
            ItemMeta im = item.getItemMeta();
            ArrayList<String> newLore = new ArrayList<String>();
            for (String lore : item.getItemMeta().getLore()) {
                Matcher valueMatcher = ItemManager.DurabilityRegex.matcher(lore);
                if (valueMatcher.find()) {
                    found = true;
                    int d = Integer.valueOf(valueMatcher.group(1));
                    int dM = Integer.valueOf(valueMatcher.group(2));
                    if (d <= 0) {
                        return false;
                    }
                    lore = valueMatcher.replaceAll("Durability " + d + " / " + dM);
                    if (item.getType().getMaxDurability() > 0) {
                        short p = (short)(d / dM * (item.getType().getMaxDurability() - 1));
                        item.setDurability(p);
                    }
                }
                newLore.add(lore);
            }
            im.setLore(newLore);
            item.setItemMeta(im);
        }
        return found;
    }

    public static int getMaxItemDurability(ItemStack item) {
        return item.getType().getMaxDurability();
    }
}

