/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.items;

import com.google.common.collect.Lists;
import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.io.ConfigManager;
import io.lumine.artifacts.items.Artifact;
import io.lumine.artifacts.items.DurabilityManager;
import io.lumine.artifacts.profiles.Profile;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitTriggerMetadata;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicReloadedEvent;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersion;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.projectiles.ProjectileSource;

public class ItemManager
implements Listener,
Terminable {
    public static Pattern AbilityPowerRegex;
    public static Pattern AmmunitionRegex;
    public static Pattern ArmorRegex;
    public static Pattern CriticalStrikeRegex;
    public static Pattern DurabilityRegex;
    public static Pattern DodgeRegex;
    public static Pattern LeechRegex;
    public static Pattern SpeedRegex;
    public static Pattern LoreRanges;
    public static Pattern EnchantmentRegex;
    private final Artifacts plugin;
    private ConcurrentHashMap<String, Artifact> items = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Artifact> display_lookup = new ConcurrentHashMap();
    private IOLoader<Artifacts> itemLoader;
    private List<File> itemFiles;
    private List<IOLoader<Artifacts>> itemList;
    private List<Runnable> secondPass = new ArrayList<Runnable>();
    private Map<UUID, List<ItemStack>> deathCache = new HashMap<UUID, List<ItemStack>>();
    private TerminableRegistry components = TerminableRegistry.create();

    public ItemManager(Artifacts plugin) {
        this.plugin = plugin;
        AbilityPowerRegex = Pattern.compile("[+](\\d+)[ ](" + ConfigManager.AbilityPowerKeyword + ")");
        ArmorRegex = Pattern.compile("[+](\\d+)[ ](" + ConfigManager.ArmorKeyword + ")");
        CriticalStrikeRegex = Pattern.compile("[+](\\d+)[ ](" + ConfigManager.CriticalStrikeKeyword + ")");
        AmmunitionRegex = Pattern.compile("Ammunition[ ](\\d+)[ ]/[ ](\\d+)");
        DurabilityRegex = Pattern.compile("Durability[ ](\\d+)[ ]/[ ](\\d+)");
        DodgeRegex = Pattern.compile("[+](\\d+)[ ](" + ConfigManager.DodgeKeyword + ")");
        LeechRegex = Pattern.compile("[+](\\d+)[ ](" + ConfigManager.LeechKeyword + ")");
        SpeedRegex = Pattern.compile("[+](\\d+)[ ](" + ConfigManager.SpeedKeyword + ")");
        LoreRanges = Pattern.compile("\\{([0-9]*)-([0-9]*)\\}");
        EnchantmentRegex = Pattern.compile("Spellweaving ([IV]+)");
        Schedulers.sync().runLater(() -> {
            this.loadItems();
            Log.info((String)("Loaded " + this.items.size() + " items."));
        }, 20L);
    }

    public void close() {
        this.components.terminate();
    }

    public void queueSecondPass(Runnable r) {
        this.secondPass.add(r);
    }

    public void loadItems() {
        this.items.clear();
        this.display_lookup.clear();
        ItemManager itemManager = this;
        for (MythicItem item : itemManager.plugin.core().getItemManager().getItems()) {
            String name = item.getDisplayName();
            if (ServerVersion.isAfterOrEq((MinecraftVersion)MinecraftVersions.v1_13) && name != null && name.startsWith("" + ChatColor.WHITE)) {
                name = name.substring(2);
            }
            try {
                Artifact artifact = new Artifact(item);
                this.items.put(item.getInternalName(), artifact);
                String material = item.getMaterial().toString().toUpperCase();
                String lookup = material + "_" + name;
                this.display_lookup.put(lookup, artifact);
            }
            catch (Exception ex) {
                Artifacts.error("Failed to load Artifact skills for item " + item.getInternalName());
            }
        }
        this.secondPass.forEach(runnable -> runnable.run());
        this.secondPass.clear();
        MythicMobs.inst().getSkillManager().runSecondPass();
        Log.info((String)"Attached Artifact traits to items.");
    }

    public Optional<Artifact> getItem(String item) {
        if (this.items.containsKey(item)) {
            return Optional.of(this.items.get(item));
        }
        return Optional.empty();
    }

    public Optional<Artifact> getItem(ItemStack item) {
        String lookup;
        CompoundTag compoundTag = MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(item);
        if (compoundTag.containsKey("MYTHIC_TYPE")) {
            Artifact artifact = this.items.getOrDefault(compoundTag.getString("MYTHIC_TYPE"), null);
            return Optional.ofNullable(artifact);
        }
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && this.display_lookup.containsKey(lookup = item.getType().toString() + "_" + item.getItemMeta().getDisplayName())) {
            return Optional.of(this.display_lookup.get(lookup));
        }
        return Optional.empty();
    }

    public Collection<Artifact> getItems() {
        return this.items.values();
    }

    public Collection<String> getItemNames() {
        return this.items.keySet();
    }

    @EventHandler
    public void onMythicReload(MythicReloadedEvent event) {
        this.loadItems();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Artifacts.inst().getProfileManager().getPlayerProfile(player).parseArmor();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getProfileManager().getPlayerProfile(player).parseArmor();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Profile caster = Artifacts.inst().getProfileManager().getPlayerProfile(player);
        boolean c = caster.runSkills(SkillTrigger.SHOOT, null);
        if (c) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onConsume(PlayerItemConsumeEvent event) {
        AbstractLocation origin;
        Profile caster;
        TriggeredSkill ts;
        Optional<Artifact> citem;
        ItemStack item = event.getItem();
        if (item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null && (citem = Artifacts.inst().getItemManager().getItem(item)).isPresent() && citem.get().hasSkills(SkillTrigger.CONSUME) && (ts = new TriggeredSkill(SkillTrigger.CONSUME, (SkillCaster)(caster = Artifacts.inst().getProfileManager().getPlayerProfile(event.getPlayer())), origin = BukkitAdapter.adapt((Location)event.getPlayer().getLocation()), null, (Collection)citem.get().getSkills(SkillTrigger.CONSUME).get(), true, new Pair[0])).getCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionSplash(PotionSplashEvent event) {
        AbstractLocation origin;
        Profile caster;
        TriggeredSkill ts;
        Optional<Artifact> citem;
        if (!(event.getPotion().getShooter() instanceof Player)) {
            return;
        }
        ItemStack item = event.getPotion().getItem();
        if (item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null && (citem = Artifacts.inst().getItemManager().getItem(item)).isPresent() && citem.get().hasSkills(SkillTrigger.SPLASH_POTION) && (ts = new TriggeredSkill(SkillTrigger.SPLASH_POTION, (SkillCaster)(caster = Artifacts.inst().getProfileManager().getPlayerProfile((Player)event.getPotion().getShooter())), origin = BukkitAdapter.adapt((Location)event.getPotion().getLocation()), null, (Collection)citem.get().getSkills(SkillTrigger.SPLASH_POTION).get(), true, new Pair[0])).getCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFish(PlayerFishEvent event) {
        SkillTrigger cause;
        if (ServerVersion.isBeforeOrEq((MinecraftVersion)MinecraftVersions.v1_12)) {
            return;
        }
        Player player = event.getPlayer();
        Profile caster = Artifacts.inst().getProfileManager().getPlayerProfile(player);
        AbstractEntity trigger = event.getCaught() != null ? BukkitAdapter.adapt((Entity)event.getCaught()) : null;
        AbstractLocation origin = event.getHook() != null ? BukkitAdapter.adapt((Location)event.getHook().getLocation()) : (event.getCaught() != null ? BukkitAdapter.adapt((Location)event.getCaught().getLocation()) : BukkitAdapter.adapt((Location)player.getLocation()));
        switch (event.getState()) {
            case FISHING: {
                cause = SkillTrigger.FISH;
                break;
            }
            case BITE: {
                cause = SkillTrigger.FISH_BITE;
                break;
            }
            case CAUGHT_ENTITY: {
                cause = SkillTrigger.FISH_CATCH_ENTITY;
                break;
            }
            case CAUGHT_FISH: {
                cause = SkillTrigger.FISH_CATCH_FISH;
                break;
            }
            case FAILED_ATTEMPT: {
                cause = SkillTrigger.FISH_FAIL;
                break;
            }
            case IN_GROUND: {
                cause = SkillTrigger.FISH_GROUND;
                break;
            }
            default: {
                cause = SkillTrigger.FISH_REEL;
            }
        }
        boolean c = caster.runSkills(cause, origin, trigger);
        if (c) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityDamageEvent(EntityDamageByEntityEvent e) {
        Player p;
        Profile gs = null;
        boolean projectile = false;
        if (e.getDamager() instanceof Player) {
            p = (Player)e.getDamager();
            gs = Artifacts.inst().getProfileManager().getPlayerProfile(p);
            DurabilityManager.handleDurabilityHand(p);
        } else if (e.getDamager() instanceof Projectile) {
            projectile = true;
            if (((Projectile)e.getDamager()).getShooter() instanceof Player) {
                p = (Player)((Projectile)e.getDamager()).getShooter();
                gs = Artifacts.inst().getProfileManager().getPlayerProfile(p);
                DurabilityManager.handleDurabilityHand(p);
            }
        }
        if (gs != null) {
            if (Artifacts.inst().getConfiguration().getUseItemLoreStats().booleanValue()) {
                if (gs.rollCriticalStrike()) {
                    e.setDamage(e.getFinalDamage() * 2.0);
                }
                if (gs.getLeechPercent() > 0.0) {
                    gs.doLeechHeal(e.getFinalDamage());
                }
            }
            if (projectile) {
                boolean c = gs.runSkills(SkillTrigger.BOW_HIT, BukkitAdapter.adapt((Entity)e.getEntity()));
                if (c) {
                    e.setCancelled(true);
                }
            } else {
                boolean c = gs.runSkills(SkillTrigger.ATTACK, BukkitAdapter.adapt((Entity)e.getEntity()));
                if (c) {
                    e.setCancelled(true);
                }
            }
        }
        if (e.getEntity() instanceof Player) {
            boolean c;
            Player p2 = (Player)e.getEntity();
            gs = Artifacts.inst().getProfileManager().getPlayerProfile(p2);
            LivingEntity damager = null;
            if (e.getDamager() instanceof LivingEntity) {
                damager = (LivingEntity)e.getDamager();
            } else if (e.getDamager() instanceof Projectile && ((Projectile)e.getDamager()).getShooter() instanceof LivingEntity) {
                damager = (LivingEntity)((Projectile)e.getDamager()).getShooter();
            }
            if (damager != null && (c = gs.runSkills(SkillTrigger.DAMAGED, BukkitAdapter.adapt((Location)damager.getLocation()), BukkitAdapter.adapt((Entity)damager), meta -> BukkitTriggerMetadata.apply((SkillMetadata)meta, (EntityDamageByEntityEvent)e)))) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void InteractEntityEvent(PlayerInteractAtEntityEvent e) {
        Profile gs = Artifacts.inst().getProfileManager().getPlayerProfile(e.getPlayer());
        boolean c = gs.runSkills(SkillTrigger.INTERACT, BukkitAdapter.adapt((Entity)e.getRightClicked()));
        if (c) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void InteractEvent(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        Profile gs = Artifacts.inst().getProfileManager().getPlayerProfile(e.getPlayer());
        switch (e.getAction()) {
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                boolean c = gs.runSkills(SkillTrigger.SWING, (AbstractEntity)gs.getPlayer());
                if (!c) break;
                e.setCancelled(true);
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                if (player.getInventory().getItemInHand() != null && player.getInventory().getItemInHand().getType() != Material.AIR) {
                    boolean cc = gs.runSkills(SkillTrigger.USE, (AbstractEntity)gs.getPlayer());
                    if (!cc) break;
                    e.setCancelled(true);
                    break;
                }
                try {
                    boolean ccc = gs.runSkills(SkillTrigger.RIGHTCLICK, (AbstractEntity)gs.getPlayer());
                    if (ccc) {
                        e.setCancelled(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            default: {
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onKillTrigger(EntityDeathEvent event) {
        ProjectileSource ps;
        EntityDamageEvent entityDamageEvent;
        LivingEntity killed = event.getEntity();
        Player killer = killed.getKiller();
        if (killer == null && (entityDamageEvent = event.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            killer = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
        }
        if (killer instanceof Projectile && (ps = ((Projectile)killer).getShooter()) instanceof LivingEntity) {
            killer = (Entity)ps;
        }
        if (killer instanceof Player) {
            Profile killerProfile = Artifacts.inst().getProfileManager().getPlayerProfile(killer);
            killerProfile.runSkills(SkillTrigger.KILL, BukkitAdapter.adapt((Entity)killed));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerKillTrigger(PlayerDeathEvent event) {
        ProjectileSource ps;
        EntityDamageEvent entityDamageEvent;
        Player killed = event.getEntity();
        Player killer = killed.getKiller();
        if (killer == null && (entityDamageEvent = event.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            killer = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
        }
        if (killer instanceof Projectile && (ps = ((Projectile)killer).getShooter()) instanceof LivingEntity) {
            killer = (Entity)ps;
        }
        if (killer instanceof Player) {
            Profile killerProfile = Artifacts.inst().getProfileManager().getPlayerProfile(killer);
            killerProfile.runSkills(SkillTrigger.KILLPLAYER, (AbstractEntity)BukkitAdapter.adapt((Player)killed));
        }
        Profile killedProfile = Artifacts.inst().getProfileManager().getPlayerProfile(killed);
        killedProfile.runSkills(SkillTrigger.DEATH, BukkitAdapter.adapt((Entity)killer));
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Optional<Artifact> artifact;
        Player player;
        if (event.getRightClicked().getType() == EntityType.ITEM_FRAME && (player = event.getPlayer()).getItemInHand().getItemMeta() != null && player.getItemInHand().getItemMeta().getDisplayName() != null && (artifact = Artifacts.inst().getItemManager().getItem(player.getItemInHand())).isPresent()) {
            if (artifact.get().isDestroy()) {
                player.getItemInHand().setType(Material.AIR);
                player.getItemInHand().setAmount(0);
                event.setCancelled(true);
            }
            if (artifact.get().preventDropping()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerArmorStandManipulateEvent event) {
        Optional<Artifact> artifact;
        Player player = event.getPlayer();
        if (player.getItemInHand().getItemMeta() != null && player.getItemInHand().getItemMeta().getDisplayName() != null && (artifact = Artifacts.inst().getItemManager().getItem(player.getItemInHand())).isPresent()) {
            if (artifact.get().isDestroy()) {
                player.getItemInHand().setType(Material.AIR);
                player.getItemInHand().setAmount(0);
                event.setCancelled(true);
            }
            if (artifact.get().preventDropping()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Optional<Artifact> citem;
        if (event.getItemInHand().getItemMeta() != null && event.getItemInHand().getItemMeta().getDisplayName() != null && (citem = Artifacts.inst().getItemManager().getItem(event.getItemInHand())).isPresent()) {
            event.setCancelled(true);
            if (citem.get().hasSkills(SkillTrigger.SPLASH_POTION)) {
                Profile caster = Artifacts.inst().getProfileManager().getPlayerProfile(event.getPlayer());
                AbstractLocation origin = BukkitAdapter.adapt((Location)event.getBlock().getLocation());
                TriggeredSkill triggeredSkill = new TriggeredSkill(SkillTrigger.BLOCK_PLACE, (SkillCaster)caster, origin, null, (Collection)citem.get().getSkills(SkillTrigger.BLOCK_PLACE).get(), true, new Pair[0]);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        AbstractLocation origin;
        Player player = event.getPlayer();
        Profile caster = Artifacts.inst().getProfileManager().getPlayerProfile(player);
        boolean b = caster.runSkills(SkillTrigger.BLOCK_BREAK, origin = BukkitAdapter.adapt((Location)event.getBlock().getLocation()), (AbstractEntity)caster.getPlayer());
        if (b) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemClickDestroy(InventoryClickEvent event) {
        Optional<Artifact> item;
        ItemStack itemStack = event.getCursor();
        if (itemStack != null && itemStack.getItemMeta() != null && itemStack.getItemMeta().getDisplayName() != null && (item = Artifacts.inst().getItemManager().getItem(itemStack)).isPresent() && item.get().isDestroy()) {
            event.setCursor(new ItemStack(Material.AIR));
            return;
        }
        itemStack = event.getCurrentItem();
        if (itemStack != null && itemStack.getItemMeta() != null && itemStack.getItemMeta().getDisplayName() != null && (item = Artifacts.inst().getItemManager().getItem(itemStack)).isPresent() && item.get().isDestroy()) {
            event.setCurrentItem(new ItemStack(Material.AIR));
            return;
        }
        if ((event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) && (itemStack = event.getView().getBottomInventory().getItem(event.getHotbarButton())) != null && itemStack.getItemMeta() != null && itemStack.getItemMeta().getDisplayName() != null && (item = Artifacts.inst().getItemManager().getItem(itemStack)).isPresent() && item.get().isDestroy()) {
            event.getView().getBottomInventory().setItem(event.getHotbarButton(), new ItemStack(Material.AIR));
            return;
        }
    }

    @EventHandler
    public void onItemClick(InventoryClickEvent event) {
        Optional<Artifact> item;
        if (event.getClickedInventory() instanceof PlayerInventory && (event.getInventory() instanceof PlayerInventory || event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        ItemStack itemStack = event.getCursor();
        if (itemStack != null && itemStack.getItemMeta() != null && itemStack.getItemMeta().getDisplayName() != null && (item = Artifacts.inst().getItemManager().getItem(itemStack)).isPresent()) {
            if (item.get().isDestroy()) {
                itemStack.setType(Material.AIR);
                itemStack.setAmount(0);
                return;
            }
            if (item.get().getPermission().isPresent() && !event.getWhoClicked().hasPermission(item.get().getPermission().get())) {
                itemStack.setType(Material.AIR);
                return;
            }
            if (item.get().destroyOnDrop()) {
                itemStack.setType(Material.AIR);
            }
            if (item.get().preventDropping()) {
                event.setCancelled(true);
                return;
            }
        }
        if ((itemStack = event.getCurrentItem()) != null && itemStack.getItemMeta() != null && itemStack.getItemMeta().getDisplayName() != null && (item = Artifacts.inst().getItemManager().getItem(itemStack)).isPresent()) {
            if (item.get().isDestroy()) {
                itemStack.setType(Material.AIR);
                return;
            }
            if (item.get().getPermission().isPresent() && !event.getWhoClicked().hasPermission(item.get().getPermission().get())) {
                itemStack.setType(Material.AIR);
                return;
            }
            if (item.get().destroyOnDrop()) {
                itemStack.setType(Material.AIR);
            }
            if (item.get().preventDropping()) {
                event.setCancelled(true);
                return;
            }
        }
        if ((event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) && (itemStack = event.getView().getBottomInventory().getItem(event.getHotbarButton())) != null && itemStack.getItemMeta() != null && itemStack.getItemMeta().getDisplayName() != null && (item = Artifacts.inst().getItemManager().getItem(itemStack)).isPresent()) {
            if (item.get().getPermission().isPresent() && !event.getWhoClicked().hasPermission(item.get().getPermission().get())) {
                itemStack.setType(Material.AIR);
                return;
            }
            if (item.get().destroyOnDrop()) {
                itemStack.setType(Material.AIR);
                itemStack.setAmount(0);
            }
            if (item.get().preventDropping()) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Optional<Artifact> item;
        if (event.getItemDrop().getItemStack().getItemMeta() != null && event.getItemDrop().getItemStack().getItemMeta().getDisplayName() != null && (item = Artifacts.inst().getItemManager().getItem(event.getItemDrop().getItemStack())).isPresent()) {
            if (item.get().getPermission().isPresent() && !event.getPlayer().hasPermission(item.get().getPermission().get())) {
                event.getItemDrop().getItemStack().setType(Material.AIR);
                event.setCancelled(true);
                return;
            }
            if (item.get().isDestroy() || item.get().destroyOnDrop()) {
                event.getItemDrop().remove();
            } else if (item.get().preventDropping()) {
                event.setCancelled(true);
                return;
            }
            Artifacts.inst().getProfileManager().getPlayerProfile(event.getPlayer()).parseWeapons();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        event.getDrops().removeIf(item -> {
            Optional<Artifact> citem;
            if (item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null && (citem = Artifacts.inst().getItemManager().getItem((ItemStack)item)).isPresent()) {
                if (!event.getKeepInventory() && citem.get().getKeepOnDeath()) {
                    if (citem.get().getPermission().isPresent() && !event.getEntity().hasPermission(citem.get().getPermission().get())) {
                        item.setType(Material.AIR);
                        return true;
                    }
                    this.deathCache.putIfAbsent(event.getEntity().getUniqueId(), Lists.newArrayList());
                    this.deathCache.get(event.getEntity().getUniqueId()).add((ItemStack)item);
                    return true;
                }
                if (citem.get().isDestroy() || citem.get().destroyOnDrop()) {
                    item.setType(Material.AIR);
                } else if (citem.get().preventDropping()) {
                    return true;
                }
            }
            return false;
        });
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.deathCache.containsKey(player.getUniqueId())) {
            this.deathCache.remove(player.getUniqueId()).forEach(item -> player.getInventory().addItem(new ItemStack[]{item}));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityDamagedEvent(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            Player p = (Player)e.getEntity();
            Profile gs = Artifacts.inst().getProfileManager().getPlayerProfile(p);
            if (!(e instanceof EntityDamageByEntityEvent)) {
                gs.runSkills(SkillTrigger.DAMAGED, null);
            }
            if (!Artifacts.inst().getConfiguration().getUseItemLoreStats().booleanValue()) {
                return;
            }
            if (p.getNoDamageTicks() == 0) {
                DurabilityManager.handleDurabilityArmor(p);
            }
            if (gs != null) {
                EntityDamageEvent.DamageCause dc = e.getCause();
                if (dc.equals((Object)EntityDamageEvent.DamageCause.FIRE) || dc.equals((Object)EntityDamageEvent.DamageCause.FIRE_TICK) || dc.equals((Object)EntityDamageEvent.DamageCause.LAVA)) {
                    if (gs.getFireResistMitigation() > 0.0) {
                        if (e.isApplicable(EntityDamageEvent.DamageModifier.ARMOR)) {
                            e.setDamage(EntityDamageEvent.DamageModifier.ARMOR, 1.0E-4);
                        }
                        if (e.isApplicable(EntityDamageEvent.DamageModifier.MAGIC)) {
                            e.setDamage(EntityDamageEvent.DamageModifier.MAGIC, 0.0);
                        }
                        e.setDamage(EntityDamageEvent.DamageModifier.BASE, e.getDamage(EntityDamageEvent.DamageModifier.BASE) * gs.getFireResistMultiplier());
                    }
                } else if (gs.getArmorMitigation() > 0.0) {
                    if (e.isApplicable(EntityDamageEvent.DamageModifier.ARMOR)) {
                        e.setDamage(EntityDamageEvent.DamageModifier.ARMOR, 1.0E-4);
                    }
                    if (e.isApplicable(EntityDamageEvent.DamageModifier.MAGIC)) {
                        e.setDamage(EntityDamageEvent.DamageModifier.MAGIC, 0.0);
                    }
                    e.setDamage(EntityDamageEvent.DamageModifier.BASE, e.getDamage(EntityDamageEvent.DamageModifier.BASE) * gs.getArmorMultiplier());
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void disableItemBreak(PlayerItemBreakEvent event) {
        DurabilityManager.handleItemBreak(event.getBrokenItem());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void eventCraft(CraftItemEvent event) {
        try {
            ItemMeta im;
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            ItemStack item = event.getCurrentItem();
            if (item.hasItemMeta() && (im = item.getItemMeta()).hasLore()) {
                ArrayList<String> parsedLore = new ArrayList<String>();
                int num = 0;
                for (String str : im.getLore()) {
                    if (str.contains("{")) {
                        Matcher pMatcher = LoreRanges.matcher(str);
                        while (pMatcher.find()) {
                            int min = Integer.parseInt(pMatcher.group(1));
                            int max = Integer.parseInt(pMatcher.group(2));
                            num = Artifacts.r.nextInt(max - min) + min;
                            str = str.replace(pMatcher.group(0), "" + num);
                            Artifacts.debug("-- Replacing number range " + pMatcher.group(0) + " with " + num);
                        }
                        str = str.replace("{lastrandom}", String.valueOf(num));
                    }
                    parsedLore.add(str);
                }
                im.setLore(parsedLore);
                item.setItemMeta(im);
                event.setCurrentItem(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

