/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.profiles;

import com.google.common.collect.Sets;
import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.enchants.AppliedEnchant;
import io.lumine.artifacts.enchants.MythicEnchantment;
import io.lumine.artifacts.io.ConfigManager;
import io.lumine.artifacts.items.Artifact;
import io.lumine.artifacts.items.EquippedItem;
import io.lumine.artifacts.items.ItemAmmo;
import io.lumine.artifacts.items.ItemManager;
import io.lumine.artifacts.items.SkillHolder;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.mechanics.MetaSkillMechanic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Profile
implements SkillCaster {
    public boolean apLockout = false;
    private AbstractPlayer player;
    private Map<Stat, Double> playerArmorStats = new HashMap<Stat, Double>();
    private Map<Stat, Double> playerWeaponStats = new HashMap<Stat, Double>();
    private Map<Stat, Double> playerTempStats = new HashMap<Stat, Double>();
    private boolean dealingDamage = false;
    private int heldItemSlot = 0;
    private Optional<Artifact> heldItem = Optional.empty();
    private SkillHolder heldSkills = null;
    private List<SkillHolder> heldEnchantSkills = new ArrayList<SkillHolder>();
    private List<SkillHolder> equippedSkills = new ArrayList<SkillHolder>();
    private boolean hasTimerSkills = true;
    private Map<SkillTrigger, Queue<SkillMechanic>> itemSkills = new HashMap<SkillTrigger, Queue<SkillMechanic>>();
    private Map<SkillTrigger, Boolean> itemSkillsInUse = new HashMap<SkillTrigger, Boolean>();
    private boolean cancelBowShoot = false;
    private Optional<ItemAmmo> ammoTracker = Optional.empty();
    private transient Collection<AbstractEntity> children = Sets.newConcurrentHashSet();
    protected int enchProtection = 0;
    protected int enchFireProtection = 0;

    public Profile(Player p) {
        this.player = BukkitAdapter.adapt((Player)p);
        for (SkillTrigger trigger : SkillTrigger.values()) {
            this.itemSkills.put(trigger, new LinkedList());
        }
    }

    public double getStat(Stat stat) {
        return this.playerArmorStats.getOrDefault((Object)stat, 0.0) + this.playerWeaponStats.getOrDefault((Object)stat, 0.0) + this.getTempStat(stat);
    }

    public void setArmorStat(Stat stat, double value) {
        this.playerArmorStats.put(stat, value);
    }

    public void setWeaponStat(Stat stat, double value) {
        this.playerWeaponStats.put(stat, value);
    }

    public double getTempStat(Stat stat) {
        if (this.playerTempStats.containsKey((Object)stat)) {
            return this.playerTempStats.get((Object)stat);
        }
        return 0.0;
    }

    public void addTempStat(Stat stat, double value) {
        double s = this.getTempStat(stat) + value;
        this.playerTempStats.put(stat, s);
    }

    public void setTempStat(Stat stat, double value) {
        this.playerTempStats.put(stat, value);
    }

    public void setPlayer(Player p) {
        this.player = BukkitAdapter.adapt((Player)p);
    }

    public AbstractPlayer getPlayer() {
        return this.player;
    }

    public double getAbilityPowerRating() {
        return this.getStat(Stat.ABILITY_POWER);
    }

    public double getAbilityPower() {
        return this.getStat(Stat.ABILITY_POWER) / Stat.ABILITY_POWER.scale();
    }

    public void setAbilityPowerLockout(boolean b) {
        this.apLockout = b;
    }

    public boolean getAbilityPowerLockout() {
        return this.apLockout;
    }

    public double getArmorRating() {
        return this.getStat(Stat.ARMOR);
    }

    public double getArmorMitigation() {
        double armor = this.getStat(Stat.ARMOR);
        double m = armor / (armor + Stat.ARMOR.scale());
        m += 0.02 * (double)this.enchProtection;
        if (BukkitAdapter.adapt((AbstractPlayer)this.player).hasPotionEffect(PotionEffectType.DAMAGE_RESISTANCE)) {
            Collection pe = BukkitAdapter.adapt((AbstractPlayer)this.player).getActivePotionEffects();
            for (PotionEffect p : pe) {
                if (!p.equals((Object)PotionEffectType.DAMAGE_RESISTANCE)) continue;
                m += 0.05 * (double)p.getAmplifier();
                break;
            }
        }
        if (m > Stat.ARMOR.max()) {
            m = Stat.ARMOR.max();
        }
        return m;
    }

    public double getArmorMultiplier() {
        return 1.0 - this.getArmorMitigation();
    }

    public double getCriticalStrikeRating() {
        return this.getStat(Stat.CRITICAL_STRIKE);
    }

    public double getCriticalStrikeChance() {
        double c = this.getStat(Stat.CRITICAL_STRIKE) / (this.getStat(Stat.CRITICAL_STRIKE) + Stat.CRITICAL_STRIKE.scale());
        if (c > Stat.CRITICAL_STRIKE.max()) {
            c = Stat.CRITICAL_STRIKE.max();
        }
        return c;
    }

    public boolean rollCriticalStrike() {
        if (!ConfigManager.STAT_ENABLED_CRITICALSTRIKE) {
            return false;
        }
        return Artifacts.r.nextDouble() < this.getCriticalStrikeChance();
    }

    public double getDodgeRating() {
        return this.getStat(Stat.DODGE);
    }

    public double getDodgeChance() {
        double c = this.getStat(Stat.DODGE) / (this.getStat(Stat.DODGE) + Stat.DODGE.scale());
        if (c > Stat.DODGE.max()) {
            c = Stat.DODGE.max();
        }
        return c;
    }

    public boolean rollDodge() {
        if (!ConfigManager.STAT_ENABLED_DODGE) {
            return false;
        }
        return Artifacts.r.nextDouble() < this.getDodgeChance();
    }

    public double getFireResistRating() {
        return this.getStat(Stat.FIRE_RESISTANCE);
    }

    public double getFireResistMitigation() {
        double armor = this.getStat(Stat.FIRE_RESISTANCE);
        double m = armor / (armor + Stat.FIRE_RESISTANCE.scale());
        m += 0.05 * (double)this.enchFireProtection;
        if (BukkitAdapter.adapt((AbstractPlayer)this.player).hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) {
            m += 0.5;
        }
        if (m > Stat.FIRE_RESISTANCE.max()) {
            m = Stat.FIRE_RESISTANCE.max();
        }
        return m;
    }

    public double getFireResistMultiplier() {
        return 1.0 - this.getFireResistMitigation();
    }

    public double getLeechRating() {
        return this.getStat(Stat.LEECH);
    }

    public double getLeechPercent() {
        if (!ConfigManager.STAT_ENABLED_LEECH) {
            return 0.0;
        }
        double c = this.getStat(Stat.LEECH) / (this.getStat(Stat.LEECH) + Stat.LEECH.scale());
        if (c > Stat.LEECH.max()) {
            c = Stat.LEECH.max();
        }
        return c;
    }

    public void doLeechHeal(double damage) {
        double heal = damage * this.getLeechPercent();
        if (this.player.getHealth() + heal > this.player.getMaxHealth()) {
            this.player.setHealth(this.player.getMaxHealth());
        } else {
            this.player.setHealth(this.player.getHealth() + heal);
        }
    }

    public double getSpeedRating() {
        return this.getStat(Stat.SPEED);
    }

    public double getSpeedMultiplier() {
        if (!ConfigManager.STAT_ENABLED_SPEED) {
            return 0.0;
        }
        double c = this.getStat(Stat.SPEED) / (this.getStat(Stat.SPEED) + Stat.SPEED.scale());
        if (c > Stat.SPEED.max()) {
            c = Stat.SPEED.max();
        }
        return c;
    }

    public void parseArmor() {
        Matcher valueMatcher;
        double statAbilityPower = 0.0;
        double statArmor = 0.0;
        double statCriticalStrike = 0.0;
        double statDodge = 0.0;
        double statLeech = 0.0;
        double statSpeed = 0.0;
        double enchProtection = 0.0;
        double enchFireProtection = 0.0;
        this.equippedSkills.clear();
        EntityEquipment ee = BukkitAdapter.adapt((AbstractPlayer)this.player).getEquipment();
        this.parseItemSkills(ee.getHelmet(), "HEAD");
        this.parseItemSkills(ee.getChestplate(), "CHEST");
        this.parseItemSkills(ee.getLeggings(), "LEGS");
        this.parseItemSkills(ee.getBoots(), "FEET");
        for (ItemStack items : BukkitAdapter.adapt((AbstractPlayer)this.player).getEquipment().getArmorContents()) {
            if (items == null || !items.hasItemMeta() || !Artifacts.inst().getConfiguration().getUseItemLoreStats().booleanValue()) continue;
            enchProtection += (double)items.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL);
            enchFireProtection += (double)items.getEnchantmentLevel(Enchantment.PROTECTION_FIRE);
            if (!items.getItemMeta().hasLore()) continue;
            String allLore = items.getItemMeta().getLore().toString();
            valueMatcher = ItemManager.AbilityPowerRegex.matcher(allLore);
            if (valueMatcher.find()) {
                statAbilityPower += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
            }
            if ((valueMatcher = ItemManager.ArmorRegex.matcher(allLore)).find()) {
                float armor = Float.valueOf(valueMatcher.group(1)).floatValue();
                statArmor += (double)armor;
            } else {
                statArmor += 100.0;
            }
            valueMatcher = ItemManager.CriticalStrikeRegex.matcher(allLore);
            if (valueMatcher.find()) {
                statCriticalStrike += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
            }
            if ((valueMatcher = ItemManager.DodgeRegex.matcher(allLore)).find()) {
                statDodge += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
            }
            if ((valueMatcher = ItemManager.LeechRegex.matcher(allLore)).find()) {
                statLeech += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
            }
            if (!(valueMatcher = ItemManager.SpeedRegex.matcher(allLore)).find()) continue;
            statSpeed += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
        }
        this.parseItemSkills(ee.getItemInOffHand(), "OFFHAND");
        ItemStack items = BukkitAdapter.adapt((AbstractPlayer)this.player).getEquipment().getItemInOffHand();
        if (items != null && items.hasItemMeta() && Artifacts.inst().getConfiguration().getUseItemLoreStats().booleanValue()) {
            enchProtection += (double)items.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL);
            enchFireProtection += (double)items.getEnchantmentLevel(Enchantment.PROTECTION_FIRE);
            if (items.getItemMeta().hasLore()) {
                String allLore = items.getItemMeta().getLore().toString();
                valueMatcher = ItemManager.AbilityPowerRegex.matcher(allLore);
                if (valueMatcher.find()) {
                    statAbilityPower += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                }
                if ((valueMatcher = ItemManager.ArmorRegex.matcher(allLore)).find()) {
                    float armor = Float.valueOf(valueMatcher.group(1)).floatValue();
                    statArmor += (double)armor;
                } else {
                    statArmor += 100.0;
                }
                valueMatcher = ItemManager.CriticalStrikeRegex.matcher(allLore);
                if (valueMatcher.find()) {
                    statCriticalStrike += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                }
                if ((valueMatcher = ItemManager.DodgeRegex.matcher(allLore)).find()) {
                    statDodge += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                }
                if ((valueMatcher = ItemManager.LeechRegex.matcher(allLore)).find()) {
                    statLeech += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                }
                if ((valueMatcher = ItemManager.SpeedRegex.matcher(allLore)).find()) {
                    statSpeed += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                }
            }
        }
        this.setArmorStat(Stat.ABILITY_POWER, statAbilityPower);
        this.setArmorStat(Stat.ARMOR, statArmor);
        this.setArmorStat(Stat.CRITICAL_STRIKE, statCriticalStrike);
        this.setArmorStat(Stat.DODGE, statDodge);
        this.setArmorStat(Stat.LEECH, statLeech);
        this.setArmorStat(Stat.SPEED, statSpeed);
        this.parseWeapons();
    }

    private void parseItemSkills(ItemStack item, String slot) {
        if (item != null && item.hasItemMeta()) {
            Optional<Artifact> ci = Artifacts.inst().getItemManager().getItem(item);
            if (ci.isPresent()) {
                if (ci.get().isDestroy()) {
                    item.setType(Material.AIR);
                    item.setAmount(0);
                    return;
                }
                this.equippedSkills.add(new EquippedItem(ci.get(), item, slot));
            }
            if (item.getType() != Material.ENCHANTED_BOOK) {
                for (Map.Entry entry : item.getEnchantments().entrySet()) {
                    Enchantment enchant = (Enchantment)entry.getKey();
                    if (!(enchant instanceof MythicEnchantment)) continue;
                    this.equippedSkills.add(new AppliedEnchant((MythicEnchantment)enchant, (Integer)entry.getValue(), slot));
                }
            }
        }
    }

    public void clearWeapon() {
        this.heldItem = Optional.empty();
        this.ammoTracker = Optional.empty();
        this.heldSkills = null;
        this.heldEnchantSkills.clear();
        this.enchProtection = 0;
        this.enchFireProtection = 0;
        this.setWeaponStat(Stat.ABILITY_POWER, 0.0);
        this.setWeaponStat(Stat.ARMOR, 0.0);
        this.setWeaponStat(Stat.CRITICAL_STRIKE, 0.0);
        this.setWeaponStat(Stat.DODGE, 0.0);
        this.setWeaponStat(Stat.LEECH, 0.0);
        this.setWeaponStat(Stat.SPEED, 0.0);
    }

    public void parseWeapons() {
        this.cancelBowShoot = false;
        this.heldItemSlot = BukkitAdapter.adapt((AbstractPlayer)this.getPlayer()).getInventory().getHeldItemSlot();
        double statAbilityPower = 0.0;
        double statArmor = 0.0;
        double statCriticalStrike = 0.0;
        double statDodge = 0.0;
        double statLeech = 0.0;
        double statSpeed = 0.0;
        this.enchProtection = 0;
        this.enchFireProtection = 0;
        this.heldItem = Optional.empty();
        this.ammoTracker = Optional.empty();
        ItemStack item = BukkitAdapter.adapt((AbstractPlayer)this.player).getEquipment().getItemInHand();
        this.heldSkills = null;
        this.heldEnchantSkills.clear();
        if (item != null) {
            this.enchProtection += item.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL);
            this.enchFireProtection += item.getEnchantmentLevel(Enchantment.PROTECTION_FIRE);
            if (item.hasItemMeta()) {
                Optional<Artifact> ci = Artifacts.inst().getItemManager().getItem(item);
                if (ci.isPresent()) {
                    if (ci.get().isDestroy()) {
                        item.setType(Material.AIR);
                        item.setAmount(0);
                        return;
                    }
                    this.heldItem = Optional.of(ci.get());
                    this.heldSkills = new EquippedItem(ci.get(), item, "HAND");
                    if (ci.get().usesAmmo()) {
                        this.ammoTracker = Optional.of(new ItemAmmo(this, ci.get()));
                    }
                }
                if (item.getType() != Material.ENCHANTED_BOOK) {
                    for (Map.Entry entry : item.getEnchantments().entrySet()) {
                        Enchantment enchant = (Enchantment)entry.getKey();
                        if (!(enchant instanceof MythicEnchantment)) continue;
                        this.heldEnchantSkills.add(new AppliedEnchant((MythicEnchantment)enchant, (Integer)entry.getValue(), "HAND"));
                    }
                }
                if (Artifacts.inst().getConfiguration().getUseItemLoreStats().booleanValue()) {
                    if (item.getItemMeta().hasLore()) {
                        Matcher valueMatcher;
                        String allLore = item.getItemMeta().getLore().toString();
                        if (ConfigManager.STAT_ENABLED_ABILITYPOWER) {
                            valueMatcher = ItemManager.AbilityPowerRegex.matcher(allLore);
                            if (valueMatcher.find()) {
                                statAbilityPower += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                            }
                            if ((valueMatcher = ItemManager.EnchantmentRegex.matcher(allLore)).find()) {
                                String lvl;
                                switch (lvl = valueMatcher.group(1)) {
                                    case "I": {
                                        statAbilityPower += 4.0;
                                        break;
                                    }
                                    case "II": {
                                        statAbilityPower += 8.0;
                                        break;
                                    }
                                    case "III": {
                                        statAbilityPower += 12.0;
                                        break;
                                    }
                                    case "IV": {
                                        statAbilityPower += 16.0;
                                        break;
                                    }
                                    case "V": {
                                        statAbilityPower += 20.0;
                                        break;
                                    }
                                }
                            }
                        }
                        if ((valueMatcher = ItemManager.ArmorRegex.matcher(allLore)).find()) {
                            statArmor += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                        }
                        if ((valueMatcher = ItemManager.CriticalStrikeRegex.matcher(allLore)).find()) {
                            statCriticalStrike += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                        }
                        if ((valueMatcher = ItemManager.DodgeRegex.matcher(allLore)).find()) {
                            statDodge += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                        }
                        if ((valueMatcher = ItemManager.LeechRegex.matcher(allLore)).find()) {
                            statLeech += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                        }
                        if ((valueMatcher = ItemManager.SpeedRegex.matcher(allLore)).find()) {
                            statSpeed += (double)Float.valueOf(valueMatcher.group(1)).floatValue();
                        }
                    }
                    this.setWeaponStat(Stat.ABILITY_POWER, statAbilityPower);
                    this.setWeaponStat(Stat.ARMOR, statArmor);
                    this.setWeaponStat(Stat.CRITICAL_STRIKE, statCriticalStrike);
                    this.setWeaponStat(Stat.DODGE, statDodge);
                    this.setWeaponStat(Stat.LEECH, statLeech);
                    this.setWeaponStat(Stat.SPEED, statSpeed);
                }
            }
        }
    }

    public boolean runSkills(SkillTrigger cause, AbstractEntity trigger) {
        return this.runSkills(cause, null, trigger, null);
    }

    public boolean runSkills(SkillTrigger cause, AbstractLocation origin, AbstractEntity trigger) {
        return this.runSkills(cause, origin, trigger, null);
    }

    public boolean runSkills(SkillTrigger cause, AbstractLocation origin, AbstractEntity trigger, Consumer<SkillMetadata> transformer) {
        if (cause == SkillTrigger.USE && this.heldSkills != null) {
            Queue<SkillMechanic> mechanics = this.heldSkills.getSkills(cause);
            if (this.ammoTracker.isPresent()) {
                if (MythicMobs.inst().getVolatileCodeHandler().getItemRecharge(BukkitAdapter.adapt((AbstractPlayer)this.player)) != 1.0f) {
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.CONDITION, (String)"Item Use Failed: item uses ammo and is recharging A", (Object[])new Object[0]);
                }
                if (MythicMobs.inst().getVolatileCodeHandler().getItemRecharging(BukkitAdapter.adapt((AbstractPlayer)this.player))) {
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.CONDITION, (String)"Item Use Failed: item uses ammo and is recharging B", (Object[])new Object[0]);
                    return false;
                }
                for (SkillMechanic skill : mechanics) {
                    if (skill.onCooldown((SkillCaster)this)) {
                        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Item Use Failed: item uses ammo and skill on cooldown", (Object[])new Object[0]);
                        return false;
                    }
                    if (!(skill instanceof MetaSkillMechanic) || !((MetaSkillMechanic)skill).getSkill().onCooldown((SkillCaster)this)) continue;
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Item Use Failed: item uses ammo and skill on cooldown 2", (Object[])new Object[0]);
                    return false;
                }
                if (!this.ammoTracker.get().useAmmo(1)) {
                    this.player.sendMessage(ChatColor.RED + "Out of Ammo");
                    return false;
                }
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Executing Ammo skill", (Object[])new Object[0]);
            return this.heldSkills.runSkills(this, cause, origin, trigger, transformer);
        }
        boolean cancel = false;
        if (this.heldSkills != null) {
            cancel = this.heldSkills.runSkills(this, cause, origin, trigger, transformer);
        }
        for (SkillHolder holder : this.heldEnchantSkills) {
            if (!holder.runSkills(this, cause, origin, trigger, transformer)) continue;
            cancel = true;
        }
        for (SkillHolder holder : this.equippedSkills) {
            if (!holder.runSkills(this, cause, origin, trigger, transformer)) continue;
            cancel = true;
        }
        return cancel;
    }

    public boolean hasTimerSkills() {
        return this.hasTimerSkills;
    }

    public void runTimerSkills(AbstractPlayer caster, long timer) {
        if (!caster.isOnline()) {
            return;
        }
        if (this.heldSkills != null && this.heldSkills.hasTimerSkills()) {
            this.heldSkills.runTimerSkills(this, timer);
        }
        this.heldEnchantSkills.forEach(holder -> {
            if (holder.hasTimerSkills()) {
                holder.runTimerSkills(this, timer);
            }
        });
        this.equippedSkills.forEach(holder -> {
            if (holder.hasTimerSkills()) {
                holder.runTimerSkills(this, timer);
            }
        });
    }

    public Optional<ItemAmmo> getAmmoTracker() {
        return this.ammoTracker;
    }

    public AbstractEntity getEntity() {
        return this.player;
    }

    public double getLevel() {
        return 0.0;
    }

    public AbstractLocation getLocation() {
        return this.player.getLocation();
    }

    public float getPower() {
        return 1.0f;
    }

    public boolean isUsingDamageSkill() {
        return this.dealingDamage;
    }

    public void setUsingDamageSkill(boolean bool) {
        this.dealingDamage = bool;
    }

    public Optional<String> getDeathMessage() {
        return Optional.empty();
    }

    public void addChild(AbstractEntity entity) {
        this.children.add(entity);
    }

    public Collection<AbstractEntity> getChildren() {
        return this.children;
    }

    public static enum Stat {
        ABILITY_POWER(160.0, 100.0),
        ARMOR(2000.0, 0.75),
        CRITICAL_STRIKE(2000.0, 1.0),
        DODGE(2000.0, 0.75),
        FIRE_RESISTANCE(2000.0, 0.75),
        LEECH(2000.0, 0.5),
        SPEED(1000.0, 1.0),
        HEALTH_REGEN(5000.0, 0.1);

        private double SCALE;
        private double MAX;

        private Stat(double scale, double max) {
            this.SCALE = scale;
            this.MAX = max;
        }

        public double max() {
            return this.MAX;
        }

        public double scale() {
            return this.SCALE;
        }
    }
}

