/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.MetaTagValue;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;

@ExternalAnnotation(name="hasmeta,hasmetasimple", author="BerndiVader")
public class HasMetaTagCondition
extends AbstractCustomCondition
implements ILocationCondition,
IEntityComparisonCondition {
    protected HashMap<String, MetaTagValue> metatags = new HashMap();
    protected boolean compareToSelf;

    public HasMetaTagCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.compareToSelf = mlc.getBoolean(new String[]{"compareself", "cs"}, false);
        if (!line.toLowerCase().startsWith("hasmetasimple")) {
            String[] metaStrings;
            String ms = mlc.getString(new String[]{"metalist", "meta", "list", "l"});
            if (ms.startsWith("\"") && ms.endsWith("\"")) {
                ms = ms.substring(1, ms.length() - 1);
            }
            ms = SkillString.parseMessageSpecialChars((String)ms);
            for (String metaString : metaStrings = ms.split("\\|\\|")) {
                String[] parse = metaString.split(";");
                String t = null;
                String v = null;
                String vt = null;
                boolean strict = true;
                for (String p : parse) {
                    if (p.startsWith("tag=")) {
                        t = p.substring(4);
                        continue;
                    }
                    if (p.startsWith("value=")) {
                        v = p.substring(6);
                        continue;
                    }
                    if (p.startsWith("type=")) {
                        vt = p.substring(5);
                        continue;
                    }
                    if (!p.startsWith("strict=")) continue;
                    strict = Boolean.parseBoolean(p.substring(7).toUpperCase());
                }
                if (t == null) continue;
                MetaTagValue mtv = new MetaTagValue(v, vt, strict);
                this.metatags.put(t, mtv);
            }
        } else {
            String t = SkillString.parseMessageSpecialChars((String)mlc.getString("tag"));
            String v = SkillString.parseMessageSpecialChars((String)mlc.getString("value"));
            String vt = SkillString.parseMessageSpecialChars((String)mlc.getString("type"));
            boolean strict = mlc.getBoolean("strict", true);
            if (t != null) {
                MetaTagValue mtv = new MetaTagValue(v, vt, strict);
                this.metatags.put(t, mtv);
            }
        }
    }

    public boolean check(AbstractLocation location) {
        Location l = BukkitAdapter.adapt((AbstractLocation)location);
        Block block = l.getBlock();
        for (Map.Entry<String, MetaTagValue> e : this.metatags.entrySet()) {
            String t = SkillString.parseMobVariables((String)e.getKey(), null, null, null);
            String vs = HasMetaTagCondition.getMetaValString(e.getValue(), null, null);
            if (!block.hasMetadata(t)) continue;
            if (e.getValue().getType().equals((Object)MetaTagValue.ValueTypes.DEFAULT)) {
                return true;
            }
            for (MetadataValue mv : block.getMetadata(t)) {
                if (!mv.asString().equals(vs)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean check(AbstractEntity caster, AbstractEntity ae) {
        ActiveMob am = Utils.mobmanager.getMythicMobInstance(caster);
        for (Map.Entry<String, MetaTagValue> e : this.metatags.entrySet()) {
            boolean strict = e.getValue().isStrict();
            String t = SkillString.parseMobVariables((String)e.getKey(), (SkillCaster)am, (AbstractEntity)ae, null);
            String vs = HasMetaTagCondition.getMetaValString(e.getValue(), am, ae);
            Entity target = this.compareToSelf ? caster.getBukkitEntity() : ae.getBukkitEntity();
            if (!target.hasMetadata(t)) continue;
            if (e.getValue().getType().equals((Object)MetaTagValue.ValueTypes.DEFAULT)) {
                return true;
            }
            for (MetadataValue mv : target.getMetadata(t)) {
                if (!(strict ? mv.asString().equals(vs) : mv.asString().contains(vs))) continue;
                return true;
            }
        }
        return false;
    }

    private static String getMetaValString(MetaTagValue v, ActiveMob am, AbstractEntity ae) {
        String vs = "";
        if (v.getType().equals((Object)MetaTagValue.ValueTypes.BOOLEAN)) {
            vs = ((Boolean)v.getValue()).toString();
        } else if (v.getType().equals((Object)MetaTagValue.ValueTypes.STRING)) {
            vs = SkillString.parseMobVariables((String)((String)v.getValue()), (SkillCaster)am, (AbstractEntity)ae, null);
        } else if (v.getType().equals((Object)MetaTagValue.ValueTypes.NUMERIC)) {
            vs = ((Double)v.getValue()).toString();
        }
        return vs;
    }
}

