/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;

@ExternalAnnotation(name="serverpackstatus", author="BerndiVader")
public class ServerpackStatusCondition
extends AbstractCustomCondition
implements IEntityCondition {
    List<EnumResourcePackStatus> stats = new ArrayList<EnumResourcePackStatus>();

    public ServerpackStatusCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String[] parse;
        for (String s1 : parse = mlc.getString("status", "SUCCESSFULLY_LOADED").toUpperCase().split(",")) {
            try {
                this.stats.add(EnumResourcePackStatus.valueOf(s1));
            }
            catch (Exception ex) {
                Main.logger.warning("Error with serverpack status. Ignore");
            }
        }
    }

    public boolean check(AbstractEntity e) {
        Entity entity = e.getBukkitEntity();
        if (entity.hasMetadata("MMERESPACKSTAT")) {
            EnumResourcePackStatus pack_status = EnumResourcePackStatus.valueOf(((MetadataValue)entity.getMetadata("MMERESPACKSTAT").get(0)).asString());
            return this.stats.contains((Object)pack_status);
        }
        return false;
    }

    private static enum EnumResourcePackStatus {
        SUCCESSFULLY_LOADED,
        DECLINED,
        FAILED_DOWNLOAD,
        ACCEPTED;

    }
}

