/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.botai.Bot;
import com.gmail.berndivader.mythicmobsext.botai.Session;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.RangedDouble;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.mechanics.AuraMechanic;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@ExternalAnnotation(name="chatlistener", author="BerndiVader")
public class ChatListenerMechanic
extends AuraMechanic
implements ITargetedEntitySkill {
    static String str = "MME_CHAT";
    static String response = "BOTRESPONSE";
    int period;
    boolean breakOnMatch;
    boolean breakOnFalse;
    boolean multi;
    boolean cancelMatch;
    boolean cancelFalse;
    boolean removephrase;
    boolean infinite;
    boolean ignoreTrigger;
    boolean sense;
    boolean strict;
    String storage;
    String botId;
    String[] phrases;
    RangedDouble radius;
    Optional<Skill> matchSkill = Optional.empty();
    Optional<Skill> falseSkill = Optional.empty();
    Optional<Skill> inuseSkill = Optional.empty();
    Optional<Skill> endSkill = Optional.empty();

    public ChatListenerMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.auraName = Optional.of(mlc.getString("chatname", "chatlistener"));
        String s1 = mlc.getString("phrases", "").toLowerCase();
        if (s1.startsWith("\"") && s1.endsWith("\"")) {
            s1 = s1.substring(1, s1.length() - 1);
        }
        this.phrases = SkillString.parseMessageSpecialChars((String)s1).split(",");
        this.period = mlc.getInteger("period", 60);
        this.radius = new RangedDouble(mlc.getString("radius", "<10"));
        this.breakOnMatch = mlc.getBoolean("breakonmatch", true);
        this.breakOnFalse = mlc.getBoolean("breakonfalse", false);
        this.cancelMatch = mlc.getBoolean("cancelmatch", false);
        this.cancelFalse = mlc.getBoolean("cancelfalse", false);
        this.removephrase = mlc.getBoolean("removephrase", false);
        this.ignoreTrigger = mlc.getBoolean("ignoretrigger", true);
        this.infinite = mlc.getBoolean("infinite", false);
        this.strict = mlc.getBoolean("strict", false);
        this.multi = mlc.getBoolean("multi", false);
        this.storage = mlc.getString("meta", null);
        this.sense = mlc.getBoolean("sensitive", true);
        this.botId = mlc.getString("bot", new String());
        s1 = mlc.getString("matchskill");
        if (s1 != null) {
            this.matchSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("falseskill")) != null) {
            this.falseSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("inuseskill")) != null) {
            this.inuseSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("endskill")) != null) {
            this.endSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
    }

    public boolean castAtEntity(SkillMetadata arg0, AbstractEntity arg1) {
        SkillMetadata sd;
        Skill sk;
        if (!this.ignoreTrigger && !arg1.isPlayer()) {
            return false;
        }
        if (this.multi && !arg1.getBukkitEntity().hasMetadata(str + this.auraName) || !this.multi && !arg0.getCaster().hasAura((String)this.auraName.get())) {
            new ChatListener(this, arg0, arg1);
            return true;
        }
        if (this.inuseSkill.isPresent() && (sk = this.inuseSkill.get()).isUsable(sd = arg0.deepClone())) {
            sk.execute(sd);
        }
        return false;
    }

    class ChatListener
    extends Aura.AuraTracker
    implements Runnable,
    IParentSkill,
    Listener {
        final ChatListenerMechanic buff;
        int ticksRemaining;
        boolean hasEnded;
        boolean bot;
        AbstractEntity p;
        Bot steve;
        Session steveSession;

        public ChatListener(ChatListenerMechanic buff, SkillMetadata data, AbstractEntity p) {
            super((Aura)ChatListenerMechanic.this, p, data);
            this.hasEnded = false;
            this.bot = false;
            this.buff = buff;
            this.ticksRemaining = buff.period;
            this.skillMetadata.setCallingEvent((IParentSkill)this);
            this.p = p;
            if (ChatListenerMechanic.this.botId.length() > 0) {
                this.steve = new Bot(ChatListenerMechanic.this.botId);
                this.steveSession = this.steve.createSession();
            }
            this.bot = this.steve != null;
            Main.pluginmanager.registerEvents((Listener)this, (Plugin)Main.getPlugin());
            p.getBukkitEntity().setMetadata(str + this.buff.auraName, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)true));
            this.start();
        }

        @Override
        public void run() {
            if (!this.buff.infinite) {
                --this.ticksRemaining;
            }
            if (this.skillMetadata.getCaster().getEntity().isDead() || !this.hasEnded && this.ticksRemaining <= 0) {
                if (ChatListenerMechanic.this.endSkill.isPresent() && ChatListenerMechanic.this.endSkill.get().isUsable(this.skillMetadata)) {
                    ChatListenerMechanic.this.endSkill.get().execute(this.skillMetadata.deepClone());
                }
                this.terminate();
            }
        }

        @EventHandler
        public void chatListener(final AsyncPlayerChatEvent e) {
            String s22;
            if (!this.buff.ignoreTrigger && e.getPlayer().getUniqueId() != this.p.getUniqueId()) {
                return;
            }
            boolean bl1 = ChatListenerMechanic.this.phrases.length == 0;
            String s2 = s22 = new PlaceholderString(e.getMessage()).get((PlaceholderMeta)this.skillMetadata, this.p);
            final String s222 = s22;
            if (!ChatListenerMechanic.this.sense) {
                s2 = s2.toLowerCase();
            }
            Skill sk = null;
            if (ChatListenerMechanic.this.radius.equals(Math.sqrt(MathUtils.distance3D(this.skillMetadata.getCaster().getEntity().getBukkitEntity().getLocation().toVector(), e.getPlayer().getLocation().toVector())))) {
                if (!this.bot) {
                    for (int i1 = 0; i1 < ChatListenerMechanic.this.phrases.length; ++i1) {
                        String s4 = new PlaceholderString(ChatListenerMechanic.this.phrases[i1]).get((PlaceholderMeta)this.skillMetadata, this.p);
                        if (!ChatListenerMechanic.this.sense) {
                            s4 = s4.toLowerCase();
                        }
                        if (!(bl1 = this.buff.strict ? s2.equals(s4) : s2.contains(s4))) continue;
                        if (!ChatListenerMechanic.this.removephrase) break;
                        s22 = s22.replace(ChatListenerMechanic.this.phrases[i1], "");
                        break;
                    }
                    if (bl1) {
                        if (ChatListenerMechanic.this.cancelMatch) {
                            e.setCancelled(true);
                        }
                        if (ChatListenerMechanic.this.storage != null) {
                            String s3 = new PlaceholderString(ChatListenerMechanic.this.storage).get((PlaceholderMeta)this.skillMetadata, this.p);
                            this.skillMetadata.getCaster().getEntity().getBukkitEntity().setMetadata(s3, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)s22));
                        }
                        if (ChatListenerMechanic.this.matchSkill.isPresent() && (sk = ChatListenerMechanic.this.matchSkill.get()).isUsable(this.skillMetadata)) {
                            sk.execute(this.skillMetadata.deepClone());
                        }
                        if (ChatListenerMechanic.this.breakOnMatch) {
                            this.terminate();
                        }
                    } else {
                        if (ChatListenerMechanic.this.cancelFalse) {
                            e.setCancelled(true);
                        }
                        if (ChatListenerMechanic.this.falseSkill.isPresent() && (sk = ChatListenerMechanic.this.falseSkill.get()).isUsable(this.skillMetadata)) {
                            sk.execute(this.skillMetadata.deepClone());
                        }
                        if (ChatListenerMechanic.this.breakOnFalse) {
                            this.terminate();
                        }
                    }
                } else {
                    new BukkitRunnable(){

                        public void run() {
                            String thought;
                            try {
                                thought = ChatListener.this.steveSession.think(s222);
                            }
                            catch (Exception e1) {
                                thought = new String();
                                e1.printStackTrace();
                            }
                            if (thought.length() > 0) {
                                ActiveMob am = (ActiveMob)ChatListener.this.skillMetadata.getCaster();
                                if (am != null) {
                                    am.setStance(thought);
                                    am.signalMob((AbstractEntity)BukkitAdapter.adapt((Player)e.getPlayer()), response);
                                } else {
                                    e.getPlayer().sendMessage(thought);
                                }
                            }
                        }
                    }.runTaskAsynchronously((Plugin)Main.getPlugin());
                }
            }
        }

        public boolean getCancelled() {
            return this.hasTerminated();
        }

        public void setCancelled() {
            this.terminate();
        }

        public boolean terminate() {
            if (!this.hasEnded) {
                if (ChatListenerMechanic.this.auraName.isPresent()) {
                    this.skillMetadata.getCaster().unregisterAura((String)ChatListenerMechanic.this.auraName.get(), (Aura.AuraTracker)this);
                }
                this.hasEnded = true;
            }
            HandlerList.unregisterAll((Listener)this);
            this.p.getBukkitEntity().removeMetadata(str + this.buff.auraName, (Plugin)Main.getPlugin());
            this.close();
            return true;
        }
    }
}

