/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Vec2D;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import com.gmail.berndivader.mythicmobsext.volatilecode.Volatile;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@ExternalAnnotation(name="forcedirection", author="BerndiVader")
public class ForceDirectionMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    BlockFace faceing;
    long duration;
    double noise;

    public ForceDirectionMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.faceing = BlockFace.valueOf((String)mlc.getString("faceing", "north").toUpperCase());
        this.duration = mlc.getInteger("duration", 1);
        this.noise = mlc.getDouble("noise", 0.0);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        final Player p = (Player)target.getBukkitEntity();
        Location source = p.getEyeLocation();
        double dx = 0.0;
        double dz = 0.0;
        switch (this.faceing) {
            case NORTH: {
                dz = -1.0;
                break;
            }
            case SOUTH: {
                dz = 1.0;
                break;
            }
            case WEST: {
                dx = -1.0;
                break;
            }
            case EAST: {
                dx = 1.0;
                break;
            }
        }
        final Location dd = source.clone().add(dx, 0.0, dz);
        final long d = this.duration;
        final double noise = this.noise;
        new BukkitRunnable(){
            long count = 0L;

            public void run() {
                double dx = 0.0;
                double dy = 0.0;
                double dz = 0.0;
                if (p == null || p.isDead() || this.count > d) {
                    this.cancel();
                } else {
                    if (noise > 0.0) {
                        ThreadLocalRandom r = ThreadLocalRandom.current();
                        dx += r.nextDouble(noise * -1.0, noise);
                        dy += r.nextDouble(noise * -1.0, noise);
                        dz += r.nextDouble(noise * -1.0, noise);
                    }
                    Vec2D v = MathUtils.lookAtVec(p.getEyeLocation(), dd.add(dx, dy, dz));
                    Volatile.handler.playerConnectionLookAt((Entity)p, (float)v.getX(), (float)v.getY());
                }
                dd.subtract(dx, dy, dz);
                ++this.count;
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getPlugin(), 1L, 1L);
        return true;
    }
}

