/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

@ExternalAnnotation(name="jumpto", author="BerndiVader")
public class JumpCasterExtMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    double height;
    double gravity;
    double speed;
    boolean use_speed;
    boolean use_gravity;

    public JumpCasterExtMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.height = mlc.getDouble("height", 2.0);
        this.gravity = mlc.getDouble("gravity", -1337.0);
        this.use_gravity = this.gravity != -1337.0;
        this.speed = mlc.getDouble("speed", -1337.0);
        this.use_speed = this.speed != -1337.0;
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity t) {
        return this.castAtLocation(data, t.getLocation());
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation l) {
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        Location destination = BukkitAdapter.adapt((AbstractLocation)l);
        if (!this.use_gravity) {
            this.gravity = Utils.getGravity(entity.getType());
        }
        entity.setVelocity(MathUtils.calculateVelocity(entity.getLocation().toVector(), destination.toVector(), this.gravity, this.height));
        return true;
    }
}

