/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.MetaTagValue;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.block.Block;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="setmeta", author="BerndiVader")
public class SetMetatagMechanic
extends SkillMechanic
implements ITargetedLocationSkill,
ITargetedEntitySkill {
    protected PlaceholderString tag;
    protected MetaTagValue mtv;
    protected boolean useCaster;

    public SetMetatagMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.useCaster = mlc.getBoolean(new String[]{"usecaster", "uc"}, false);
        String ms = mlc.getString(new String[]{"meta", "m"}, "", new String[0]);
        if (ms.startsWith("\"") && ms.endsWith("\"")) {
            ms = ms.substring(1, ms.length() - 1);
        }
        ms = SkillString.parseMessageSpecialChars((String)ms);
        String[] parse = ms.split(";");
        String t = null;
        String v = null;
        String vt = null;
        for (int a = 0; a < parse.length; ++a) {
            String p = parse[a];
            if (p.startsWith("tag=")) {
                t = p.substring(4);
                continue;
            }
            if (p.startsWith("value=")) {
                v = p.substring(6);
                continue;
            }
            if (!p.startsWith("type=")) continue;
            vt = p.substring(5);
        }
        if (t != null) {
            this.tag = new PlaceholderString(t);
            this.mtv = new MetaTagValue(v, vt);
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Object vo;
        String parsedTag = this.tag.get((PlaceholderMeta)data, target);
        if (parsedTag == null || parsedTag.isEmpty()) {
            return false;
        }
        Object object = vo = this.mtv.getType().equals((Object)MetaTagValue.ValueTypes.STRING) ? new PlaceholderString((String)this.mtv.getValue()).get((PlaceholderMeta)data, target) : this.mtv.getValue();
        if (this.useCaster) {
            data.getCaster().getEntity().getBukkitEntity().setMetadata(parsedTag, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), vo));
        } else {
            target.getBukkitEntity().setMetadata(parsedTag, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), vo));
        }
        return true;
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation location) {
        Block target = BukkitAdapter.adapt((AbstractLocation)location).getBlock();
        String parsedTag = this.tag.get((PlaceholderMeta)data);
        if (parsedTag == null || parsedTag.isEmpty()) {
            return false;
        }
        Object vo = this.mtv.getType().equals((Object)MetaTagValue.ValueTypes.STRING) ? new PlaceholderString((String)this.mtv.getValue()).get((PlaceholderMeta)data) : this.mtv.getValue();
        target.setMetadata(parsedTag, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), vo));
        return true;
    }
}

