/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics.customprojectiles;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.mechanics.customprojectiles.CustomProjectile;
import com.gmail.berndivader.mythicmobsext.utils.MythicHitBox;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import com.gmail.berndivader.mythicmobsext.volatilecode.Volatile;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.api.exceptions.InvalidMobTypeException;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.util.BlockUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="mythicorbitalprojectile", author="BerndiVader")
public class MythicOrbitalProjectile
extends CustomProjectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String pEntityName;
    protected float pEntitySpin;
    protected int pEntityPitchOffset;
    protected float oRadiusX;
    protected float oRadiusZ;
    protected float oRadiusY;
    protected float oRadiusPerSec;
    protected boolean invisible;
    protected boolean ct;
    protected boolean tc;
    protected boolean lifetime;
    protected String tag;

    public MythicOrbitalProjectile(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.pEntityName = mlc.getString(new String[]{"pobject", "projectilemythic", "pmythic"}, "MINECART", new String[0]);
        this.pEntitySpin = mlc.getFloat("pspin", 0.0f);
        this.pEntityPitchOffset = mlc.getInteger("ppOff", 0);
        this.pFaceDirection = mlc.getBoolean("pfacedir", false);
        this.pVOffset = mlc.getDouble("pvoff", 0.0);
        this.pFOffset = mlc.getFloat("pfoff", 0.0f);
        this.oRadiusX = mlc.getFloat("oradx", 0.0f);
        this.oRadiusZ = mlc.getFloat("oradz", 0.0f);
        this.oRadiusY = mlc.getFloat("orady", 0.0f);
        this.oRadiusPerSec = mlc.getFloat("oradsec", 0.0f);
        this.targetable = mlc.getBoolean("targetable", false);
        this.tag = mlc.getString("tag");
        this.invisible = mlc.getBoolean("invis", false);
        this.ct = mlc.getBoolean("ct", false);
        this.tc = mlc.getBoolean("tc", false);
        this.lifetime = mlc.getBoolean("lt", false);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new ProjectileRunner(data, this.pEntityName, target);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public class ProjectileRunner
    implements IParentSkill,
    Runnable {
        private SkillMetadata data;
        private boolean cancelled = false;
        private SkillCaster am;
        private ActiveMob cam;
        private long startTime;
        private AbstractLocation currentLocation;
        private int taskId;
        private Set<AbstractEntity> inRange = ConcurrentHashMap.newKeySet();
        private HashSet<AbstractEntity> targets = new HashSet();
        private Map<AbstractEntity, Long> immune = new HashMap<AbstractEntity, Long>();
        private ActiveMob pam;
        private Entity pEntity;
        private Location centerLocation;
        private float radiusX;
        private float radiusZ;
        private float radiusY;
        private float radPerSec;
        private float radPerTick;
        private float pSpin;
        private int ppOff;
        private float pFOff;
        private double pVOff;
        private boolean pFaceDir;
        private int tick;
        private AbstractEntity target;
        private boolean targetable;
        private boolean ct;
        private boolean tc;
        private boolean lt;
        private String tag;

        public ProjectileRunner(SkillMetadata data, String customItemName, AbstractEntity t) {
            this.data = data;
            this.data.setCallingEvent((IParentSkill)this);
            this.am = data.getCaster();
            this.startTime = System.currentTimeMillis();
            this.ppOff = MythicOrbitalProjectile.this.pEntityPitchOffset;
            this.pSpin = MythicOrbitalProjectile.this.pEntitySpin;
            this.pFaceDir = MythicOrbitalProjectile.this.pFaceDirection;
            this.pVOff = MythicOrbitalProjectile.this.pVOffset;
            this.pFOff = MythicOrbitalProjectile.this.pFOffset;
            this.radiusX = MythicOrbitalProjectile.this.oRadiusX;
            this.radiusZ = MythicOrbitalProjectile.this.oRadiusZ;
            this.radiusY = MythicOrbitalProjectile.this.oRadiusY;
            this.radPerSec = MythicOrbitalProjectile.this.oRadiusPerSec;
            this.radPerTick = this.radPerSec / 20.0f;
            this.tick = this.ppOff;
            this.target = t;
            this.centerLocation = BukkitAdapter.adapt((AbstractLocation)this.target.getLocation().add(0.0, this.pVOff, 0.0).clone());
            this.targetable = MythicOrbitalProjectile.this.targetable;
            this.tag = MythicOrbitalProjectile.this.tag;
            this.ct = MythicOrbitalProjectile.this.ct;
            this.tc = MythicOrbitalProjectile.this.tc;
            this.lt = MythicOrbitalProjectile.this.lifetime;
            if (this.am instanceof ActiveMob) {
                this.cam = (ActiveMob)this.am;
            }
            if (this.centerLocation == null) {
                return;
            }
            try {
                this.currentLocation = MathUtils.getCircleLoc(this.centerLocation, this.radiusX, this.radiusZ, this.radiusY, this.radPerTick * (float)this.tick);
                this.pEntity = MythicOrbitalProjectile.this.mythicmobs.getAPIHelper().spawnMythicMob(customItemName, BukkitAdapter.adapt((AbstractLocation)this.currentLocation));
                this.pEntity.setMetadata("mythicprojectile", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), null));
                if (!this.targetable) {
                    Volatile.handler.changeHitBox(this.pEntity, 0.0, 0.0, 0.0);
                }
                this.pEntity.setMetadata("nottargetable", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), null));
            }
            catch (InvalidMobTypeException e1) {
                e1.printStackTrace();
                return;
            }
            this.pam = MythicOrbitalProjectile.this.mobmanager.getMythicMobInstance(this.pEntity);
            this.pam.setOwner(this.am.getEntity().getUniqueId());
            if (this.tc) {
                this.pam.setTarget(data.getCaster().getEntity());
            } else if (this.ct) {
                if (this.cam != null && this.cam.hasThreatTable() && this.cam.getThreatTable().size() > 0) {
                    this.pam.setTarget(this.cam.getThreatTable().getTopThreatHolder());
                } else if (this.cam.getEntity().getTarget() != null) {
                    this.pam.setTarget(this.cam.getEntity().getTarget());
                }
            }
            if (this.tag != null) {
                this.tag = SkillString.parseMobVariables((String)this.tag, (SkillCaster)this.pam, (AbstractEntity)this.am.getEntity().getTarget(), (AbstractEntity)this.am.getEntity());
                this.pEntity.setMetadata(this.tag, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), null));
            }
            this.taskId = TaskManager.get().scheduleTask((Runnable)this, 0, 1);
            if (MythicOrbitalProjectile.this.hitPlayers || MythicOrbitalProjectile.this.hitNonPlayers) {
                this.inRange.addAll(MythicOrbitalProjectile.this.entitymanager.getLivingEntities(this.currentLocation.getWorld()));
                this.inRange.removeIf(e -> {
                    if (e != null) {
                        if (e.getUniqueId().equals(this.am.getEntity().getUniqueId()) || e.getBukkitEntity().hasMetadata("nottargetable")) {
                            return true;
                        }
                        if (!MythicOrbitalProjectile.this.hitPlayers && e.isPlayer()) {
                            return true;
                        }
                        return !MythicOrbitalProjectile.this.hitNonPlayers && !e.isPlayer();
                    }
                    return true;
                });
            }
            if (MythicOrbitalProjectile.this.onStartSkill.isPresent() && ((Skill)MythicOrbitalProjectile.this.onStartSkill.get()).isUsable(data)) {
                SkillMetadata sData = this.data.deepClone();
                sData.setCaster((SkillCaster)this.pam);
                sData.setTrigger(sData.getCaster().getEntity());
                AbstractEntity entity = BukkitAdapter.adapt((Entity)this.pEntity);
                HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
                targets.add(entity);
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation);
                ((Skill)MythicOrbitalProjectile.this.onStartSkill.get()).execute(sData);
            }
        }

        @Override
        public void run() {
            ++this.tick;
            if (this.radPerTick * (float)this.tick > 360.0f) {
                this.tick = 0;
            }
            if (this.cancelled) {
                return;
            }
            if (this.am != null && this.am.getEntity().isDead()) {
                this.stop();
                return;
            }
            if (this.lt && this.startTime + MythicOrbitalProjectile.this.duration < System.currentTimeMillis()) {
                this.stop();
                return;
            }
            if (this.pam == null || this.pam.getEntity().isDead() || this.target == null || this.target.isDead()) {
                this.stop();
                return;
            }
            this.centerLocation = this.target.getBukkitEntity().getLocation().clone().add(0.0, this.pVOff, 0.0);
            this.currentLocation = MathUtils.getCircleLoc(this.centerLocation, this.radiusX, this.radiusZ, this.radiusY, this.radPerTick * (float)this.tick);
            if (MythicOrbitalProjectile.this.stopOnHitGround && !BlockUtil.isPathable((Block)BukkitAdapter.adapt((AbstractLocation)this.currentLocation).getBlock())) {
                this.stop();
                return;
            }
            Location eloc = this.pEntity.getLocation().clone();
            float yaw = eloc.getYaw();
            if (this.pFaceDir) {
                yaw = MathUtils.lookAtYaw(eloc, BukkitAdapter.adapt((AbstractLocation)this.currentLocation));
            } else if ((double)this.pSpin != 0.0) {
                yaw = (yaw + this.pSpin) % 360.0f;
            }
            NMSUtils.setLocation(this.pEntity, this.currentLocation.getX(), this.currentLocation.getY(), this.currentLocation.getZ(), yaw, eloc.getPitch());
            this.targets.clear();
            if (this.ct) {
                if (this.cam != null && this.cam.hasThreatTable() && this.cam.getThreatTable().size() > 0) {
                    this.pam.setTarget(this.cam.getThreatTable().getTopThreatHolder());
                } else if (this.cam.getEntity().getTarget() != null) {
                    this.pam.setTarget(this.cam.getEntity().getTarget());
                }
            }
            if (this.inRange != null) {
                MythicHitBox hitBox = new MythicHitBox(this.currentLocation, MythicOrbitalProjectile.this.hitRadius, MythicOrbitalProjectile.this.verticalHitRadius);
                for (AbstractEntity e : this.inRange) {
                    if (e.isDead() || !hitBox.contains(e.getLocation().add(0.0, 0.6, 0.0))) continue;
                    this.targets.add(e);
                    this.immune.put(e, System.currentTimeMillis());
                    break;
                }
                this.immune.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - 2000L);
            }
            if (MythicOrbitalProjectile.this.onTickSkill.isPresent() && ((Skill)MythicOrbitalProjectile.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                sData.setCaster((SkillCaster)this.pam);
                sData.setTrigger(sData.getCaster().getEntity());
                AbstractEntity entity = BukkitAdapter.adapt((Entity)this.pEntity);
                HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
                targets.add(entity);
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation);
                ((Skill)MythicOrbitalProjectile.this.onTickSkill.get()).execute(sData);
            }
            if (this.targets.size() > 0) {
                this.doHit((HashSet)this.targets.clone());
                if (MythicOrbitalProjectile.this.stopOnHitEntity) {
                    this.stop();
                }
            }
            this.targets.clear();
        }

        private void doHit(HashSet<AbstractEntity> targets) {
            if (MythicOrbitalProjectile.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (((Skill)MythicOrbitalProjectile.this.onHitSkill.get()).isUsable(sData)) {
                    ((Skill)MythicOrbitalProjectile.this.onHitSkill.get()).execute(sData);
                }
            }
        }

        private void stop() {
            if (MythicOrbitalProjectile.this.onEndSkill.isPresent() && ((Skill)MythicOrbitalProjectile.this.onEndSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                ((Skill)MythicOrbitalProjectile.this.onEndSkill.get()).execute(sData.setOrigin(this.currentLocation).setLocationTarget(this.currentLocation));
            }
            TaskManager.get().cancelTask(this.taskId);
            this.pEntity.remove();
            this.cancelled = true;
        }

        public void setCancelled() {
            this.stop();
        }

        public boolean getCancelled() {
            return this.cancelled;
        }
    }
}

