/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitEnderman
extends BukkitEntityType {
    private static final int height = 1;
    private Material heldBlock = Material.AIR;

    @Override
    public void instantiate(MythicConfig mc) {
        try {
            this.heldBlock = Material.valueOf((String)mc.getString("Options.HeldBlock", "AIR"));
        }
        catch (Error | Exception ex) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid Material specified for Options.HeldBlock");
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.ENDERMAN, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Enderman e = (Enderman)entity;
        if (this.heldBlock != Material.AIR) {
            e.setCarriedBlock(this.heldBlock.createBlockData());
        }
        return entity;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Enderman;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

