/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.utility;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.commands.utility.ActiveInfoCommand;
import io.lumine.xikage.mythicmobs.commands.utility.ActiveRemoveCommand;
import io.lumine.xikage.mythicmobs.commands.utility.AddEntityNBTCommand;
import io.lumine.xikage.mythicmobs.commands.utility.BroadcastCommand;
import io.lumine.xikage.mythicmobs.commands.utility.GetBlockCoordinatesCommand;
import io.lumine.xikage.mythicmobs.commands.utility.GetItemInfoCommand;
import io.lumine.xikage.mythicmobs.commands.utility.GetPathStringCommand;
import io.lumine.xikage.mythicmobs.commands.utility.GetTargetInfoCommand;
import io.lumine.xikage.mythicmobs.commands.utility.GetTargetNBTCommand;
import io.lumine.xikage.mythicmobs.commands.utility.ListAllEntitiesCommand;
import io.lumine.xikage.mythicmobs.commands.utility.TestEntityNBTCommand;
import io.lumine.xikage.mythicmobs.skills.IDummySkill;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.util.reflections.Reflections;
import io.lumine.xikage.mythicmobs.util.reflections.scanners.Scanner;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;

public class UtilitiesCommand
extends Command<MythicMobs> {
    public UtilitiesCommand(Command<MythicMobs> parent) {
        super(parent);
        this.addSubCommands(new BroadcastCommand(this), new GetBlockCoordinatesCommand(this), new GetItemInfoCommand(this), new GetTargetInfoCommand(this), new AddEntityNBTCommand(this), new TestEntityNBTCommand(this), new GetTargetNBTCommand(this), new GetPathStringCommand(this), new ActiveInfoCommand(this), new ActiveRemoveCommand(this), new ListAllEntitiesCommand(this));
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("generatedocs")) {
            String docsFolder = ((MythicMobs)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Docs";
            String mechanicsFolder = docsFolder + System.getProperty("file.separator") + "Mechanics";
            String mechanicsFile = docsFolder + System.getProperty("file.separator") + "mechanics.txt";
            File file = new File(docsFolder);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(mechanicsFolder)).exists()) {
                file.mkdir();
            }
            if ((file = new File(mechanicsFile)).exists()) {
                file.delete();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try (PrintWriter out = new PrintWriter(mechanicsFile);){
                Set<Class<?>> mechanicsClasses = new Reflections("io.lumine.xikage.mythicmobs.skills.mechanics", new Scanner[0]).getTypesAnnotatedWith(MythicMechanic.class);
                for (Class clazz : mechanicsClasses.stream().sorted((a, b) -> a.getAnnotation(MythicMechanic.class).name().compareTo(b.getAnnotation(MythicMechanic.class).name())).collect(Collectors.toList())) {
                    try {
                        String name = StringUtils.capitalize((String)clazz.getAnnotation(MythicMechanic.class).name());
                        String author = clazz.getAnnotation(MythicMechanic.class).author();
                        CharSequence[] aliases = clazz.getAnnotation(MythicMechanic.class).aliases();
                        String description = clazz.getAnnotation(MythicMechanic.class).description();
                        String version = clazz.getAnnotation(MythicMechanic.class).version();
                        String type = "";
                        if (Aura.class.isAssignableFrom(clazz)) {
                            type = type + "Aura";
                        } else {
                            if (IDummySkill.class.isAssignableFrom(clazz)) {
                                type = "Dummy";
                            }
                            if (IMetaSkill.class.isAssignableFrom(clazz)) {
                                if (type.length() > 0) {
                                    type = type + ", ";
                                }
                                type = type + "Meta";
                            }
                            if (INoTargetSkill.class.isAssignableFrom(clazz)) {
                                if (type.length() > 0) {
                                    type = type + ", ";
                                }
                                type = type + "No-Target";
                            } else if (ITargetedEntitySkill.class.isAssignableFrom(clazz)) {
                                if (type.length() > 0) {
                                    type = type + ", ";
                                }
                                type = type + "Entity";
                            } else if (ITargetedLocationSkill.class.isAssignableFrom(clazz)) {
                                if (type.length() > 0) {
                                    type = type + ", ";
                                }
                                type = type + "Location";
                            }
                        }
                        out.println("| [[:skills:mechanics:" + name.toLowerCase() + "|" + name + "]] | " + type + " | " + description + " |");
                        String cFile = name.toLowerCase() + ".txt";
                        File cfile = new File(mechanicsFolder + System.getProperty("file.separator") + cFile);
                        if (cfile.exists()) {
                            cfile.delete();
                        }
                        cfile.createNewFile();
                        try {
                            PrintWriter cout = new PrintWriter(cfile);
                            Throwable throwable = null;
                            try {
                                ArrayList<Field> fields = new ArrayList<Field>();
                                for (Field f : clazz.getDeclaredFields()) {
                                    if (f.getAnnotations().length <= 0) continue;
                                    fields.add(f);
                                }
                                cout.println("<WRAP infobox right>");
                                cout.println("<WRAP infoboxheader>" + name + "</WRAP>");
                                cout.println("<WRAP infoboxtable>");
                                cout.println("^Type| " + type + "|");
                                if (aliases.length > 0) {
                                    cout.println("^Aliases| " + String.join((CharSequence)", ", aliases) + "|");
                                }
                                cout.println("^Added In| " + version + "|");
                                cout.println("^Author| " + author + "|");
                                cout.println("</WRAP>");
                                cout.println("</WRAP>");
                                cout.println("====== Mechanic: " + name + " ======");
                                cout.println(" ");
                                cout.println(description);
                                cout.println(" ");
                                cout.println("===== Attributes =====");
                                cout.println("^Attribute ^Aliases ^Description ^Default ^");
                                if (fields.size() == 0) {
                                    cout.println("|  |  |  |");
                                } else {
                                    for (Field field : fields) {
                                        String aName = field.getAnnotation(MythicField.class).name();
                                        CharSequence[] aAliases = field.getAnnotation(MythicField.class).aliases();
                                        String aDescription = field.getAnnotation(MythicField.class).description();
                                        String defValue = field.getAnnotation(MythicField.class).defValue();
                                        cout.println("| " + aName + " | " + String.join((CharSequence)", ", aAliases) + " | " + aDescription + " | " + defValue + " |");
                                    }
                                }
                                cout.println("\\\\");
                                cout.println(" ");
                                cout.println("===== Examples =====");
                                cout.println(" ");
                                cout.println("<code>");
                                cout.println("Skills:");
                                cout.println("- " + name.toLowerCase() + "{} true");
                                cout.println("</code>");
                                cout.println(" ");
                                cout.println(" ");
                            }
                            catch (Throwable fields) {
                                throwable = fields;
                                throw fields;
                            }
                            finally {
                                if (cout == null) continue;
                                if (throwable != null) {
                                    try {
                                        cout.close();
                                    }
                                    catch (Throwable fields) {
                                        throwable.addSuppressed(fields);
                                    }
                                    continue;
                                }
                                cout.close();
                            }
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            String conditionsFolder = docsFolder + System.getProperty("file.separator") + "Conditions";
            String conditionsFile = docsFolder + System.getProperty("file.separator") + "conditions.txt";
            file = new File(docsFolder);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(conditionsFolder)).exists()) {
                file.mkdir();
            }
            if ((file = new File(conditionsFile)).exists()) {
                file.delete();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                PrintWriter out = new PrintWriter(conditionsFile);
                Object object = null;
                try {
                    Set<Class<?>> conditionsClasses = new Reflections("io.lumine.xikage.mythicmobs.skills.conditions.all", new Scanner[0]).getTypesAnnotatedWith(MythicCondition.class);
                    for (Class clazz : conditionsClasses.stream().sorted((a, b) -> a.getAnnotation(MythicCondition.class).name().compareTo(b.getAnnotation(MythicCondition.class).name())).collect(Collectors.toList())) {
                        try {
                            String name = StringUtils.capitalize((String)clazz.getAnnotation(MythicCondition.class).name());
                            String author = clazz.getAnnotation(MythicCondition.class).author();
                            CharSequence[] aliases = clazz.getAnnotation(MythicCondition.class).aliases();
                            String description = clazz.getAnnotation(MythicCondition.class).description();
                            String version = clazz.getAnnotation(MythicCondition.class).version();
                            String type = "";
                            if (ISkillMetaCondition.class.isAssignableFrom(clazz)) {
                                type = type + "Meta";
                            } else {
                                if (IEntityCondition.class.isAssignableFrom(clazz)) {
                                    type = "Entity";
                                }
                                if (ILocationCondition.class.isAssignableFrom(clazz)) {
                                    if (type.length() > 0) {
                                        type = type + ", ";
                                    }
                                    type = type + "Location";
                                }
                                if (IEntityComparisonCondition.class.isAssignableFrom(clazz)) {
                                    if (type.length() > 0) {
                                        type = type + ", ";
                                    }
                                    type = type + "Compare";
                                } else if (ILocationComparisonCondition.class.isAssignableFrom(clazz)) {
                                    if (type.length() > 0) {
                                        type = type + ", ";
                                    }
                                    type = type + "Compare";
                                }
                            }
                            out.println("| [[:conditions:" + name.toLowerCase() + "|" + name + "]] | " + type + " | " + description + " |");
                            String cFile = name.toLowerCase() + ".txt";
                            File cfile = new File(conditionsFolder + System.getProperty("file.separator") + cFile);
                            if (cfile.exists()) {
                                cfile.delete();
                            }
                            cfile.createNewFile();
                            try {
                                PrintWriter cout = new PrintWriter(cfile);
                                Object object2 = null;
                                try {
                                    ArrayList<Field> fields = new ArrayList<Field>();
                                    for (Field f : clazz.getDeclaredFields()) {
                                        if (f.getAnnotations().length <= 0) continue;
                                        fields.add(f);
                                    }
                                    cout.println("<WRAP infobox right>");
                                    cout.println("<WRAP infoboxheader>" + name + "</WRAP>");
                                    cout.println("<WRAP infoboxtable>");
                                    cout.println("^Type| " + type + "|");
                                    if (aliases.length > 0) {
                                        cout.println("^Aliases| " + String.join((CharSequence)", ", aliases) + "|");
                                    }
                                    cout.println("^Added In| " + version + "|");
                                    cout.println("^Author| " + author + "|");
                                    cout.println("</WRAP>");
                                    cout.println("</WRAP>");
                                    cout.println("====== Condition: " + name + " ======");
                                    cout.println(" ");
                                    cout.println(description);
                                    cout.println(" ");
                                    cout.println("===== Attributes =====");
                                    cout.println("^Attribute ^Aliases ^Description ^");
                                    if (fields.size() == 0) {
                                        cout.println("|  |  |  |");
                                    } else {
                                        for (Field field : fields) {
                                            String aName = field.getAnnotation(MythicField.class).name();
                                            CharSequence[] aAliases = field.getAnnotation(MythicField.class).aliases();
                                            String aDescription = field.getAnnotation(MythicField.class).description();
                                            cout.println("| " + aName + " | " + String.join((CharSequence)", ", aAliases) + " | " + aDescription + " |");
                                        }
                                    }
                                    cout.println("\\\\");
                                    cout.println(" ");
                                    cout.println("===== Examples =====");
                                    cout.println(" ");
                                    cout.println("<code>");
                                    cout.println("Conditions:");
                                    cout.println("- " + name.toLowerCase() + "{} true");
                                    cout.println("</code>");
                                    cout.println(" ");
                                    cout.println(" ");
                                }
                                catch (Throwable throwable) {
                                    object2 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (cout == null) continue;
                                    if (object2 != null) {
                                        try {
                                            cout.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object2).addSuppressed(throwable);
                                        }
                                        continue;
                                    }
                                    cout.close();
                                }
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (object != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.utilities";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "utilities";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"utility", "u"};
    }
}

