/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.drops.MythicDropTable;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.inventory.ItemStack;

public class DropManager {
    private final MythicMobs core;
    private ConcurrentHashMap<String, DropTable> dropTables = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MythicDropTable> legacyDropTables = new ConcurrentHashMap();
    private List<Runnable> secondPass = new ArrayList<Runnable>();

    public DropManager(MythicMobs core) {
        this.core = core;
    }

    public void loadDropTables() {
        IOLoader<MythicMobs> defaultDroptables = new IOLoader<MythicMobs>(MythicMobs.inst(), "ExampleDropTables.yml", "DropTables");
        List<File> droptableFiles = IOHandler.getAllFiles(defaultDroptables.getFile().getParent());
        File packsFolder = new File(this.core.getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "DropTables")).exists() || !confFolder.isDirectory()) continue;
                droptableFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        List<IOLoader<MythicMobs>> droptableLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), droptableFiles, "DropTables");
        this.dropTables.clear();
        this.legacyDropTables.clear();
        for (IOLoader<MythicMobs> sl : droptableLoaders) {
            for (String s2 : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                if (sl.getCustomConfig().getStringList(s2 + ".Drops") == null) continue;
                String file = sl.getFile().getName();
                MythicConfig mc = new MythicConfig(s2, sl.getCustomConfig());
                DropTable dt = new DropTable(file, s2, mc);
                this.dropTables.put(s2, dt);
            }
        }
        this.runSecondPass();
    }

    public void runSecondPass() {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Doing second pass on " + this.secondPass.size() + " drops.", new Object[0]);
        this.secondPass.forEach(r -> r.run());
        this.secondPass.clear();
    }

    public void queueSecondPass(Runnable r) {
        this.secondPass.add(r);
    }

    public Optional<DropTable> getDropTable(String name) {
        return Optional.ofNullable(this.dropTables.getOrDefault(name, null));
    }

    public Collection<DropTable> getDropTables() {
        return this.dropTables.values();
    }

    public static void Drop(Location loc, int exp, List<ItemStack> drops) {
        for (ItemStack is : drops) {
            loc.getWorld().dropItemNaturally(loc, is);
        }
        if (exp != 0) {
            int i = exp % 4;
            int per = (exp - exp % 4) / 4;
            for (int y = 0; y < 4; ++y) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(per);
            }
            if (i != 0) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(i);
            }
        }
    }
}

