/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import java.util.HashSet;

public enum EquipSlot {
    HEAD("4", "HELMET", "HELM"),
    CHEST("3", "CHESTPIECE", "CHESTPLATE", "BODY"),
    LEGS("2", "LEGGINGS", "PANTS"),
    FEET("1", "BOOTS", "SHOES"),
    HAND("0", "MAINHAND", "WEAPON"),
    OFFHAND("5", "SHIELD"),
    NONE(new String[0]);

    private HashSet<String> slotAliases = new HashSet();

    private EquipSlot(String ... aliases) {
        this.slotAliases.add(this.toString());
        for (String alias : aliases) {
            this.slotAliases.add(alias);
        }
    }

    public boolean matches(String slot) {
        for (String alias : this.slotAliases) {
            if (!alias.equalsIgnoreCase(slot)) continue;
            return true;
        }
        return false;
    }

    public void equip(AbstractEntity entity, AbstractItemStack item) {
        switch (this) {
            case HEAD: {
                entity.equipItemHead(item);
                break;
            }
            case CHEST: {
                entity.equipItemChest(item);
                break;
            }
            case LEGS: {
                entity.equipItemLegs(item);
                break;
            }
            case FEET: {
                entity.equipItemFeet(item);
                break;
            }
            case HAND: {
                entity.equipItemMainHand(item);
                break;
            }
            case OFFHAND: {
                entity.equipItemOffHand(item);
                break;
            }
        }
    }

    public static EquipSlot of(String key) {
        for (EquipSlot slot : EquipSlot.values()) {
            if (!slot.matches(key)) continue;
            return slot;
        }
        return NONE;
    }
}

