/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.holograms.types;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.holograms.HologramManager;
import io.lumine.xikage.mythicmobs.holograms.IHologram;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.mechanics.CastMechanic;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.chat.ColorString;
import io.lumine.xikage.mythicmobs.utils.tasks.Task;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import org.bukkit.ChatColor;

public class CastBar
implements Terminable {
    private final CastMechanic.CastTracker castTracker;
    private final SkillCaster skillCaster;
    private final HologramManager manager;
    private Task timer;
    private IHologram nameHologram;
    private IHologram castHologram;
    private double yOffset;
    private double castPercent = 0.0;
    private TerminableRegistry components = TerminableRegistry.create();

    public CastBar(HologramManager manager, CastMechanic.CastTracker castTracker, String castText) {
        this.manager = manager;
        this.castTracker = castTracker;
        this.skillCaster = castTracker.getSkillMetadata().getCaster();
        if (this.skillCaster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)this.skillCaster;
            this.yOffset = 1.0 + am.getType().getConfig().getDouble("HealthBar.Offset", am.getType().isFakePlayer() ? (double)0.3f : am.getType().getMythicEntity().getHealthbarOffset());
        } else {
            this.yOffset = 1.3;
        }
        this.nameHologram = manager.createHologram("#TempCastBarName" + this.skillCaster.getEntity().getUniqueId().toString(), this.getLocation(), castText);
        this.castHologram = manager.createHologram("#TempCastBarCast" + this.skillCaster.getEntity().getUniqueId().toString(), this.getLocation(), this.getCastBar());
        this.components.accept(this.nameHologram);
        this.components.accept(this.castHologram);
        this.timer = Schedulers.async().runRepeating(() -> this.teleport(), 1L, 1L);
        this.components.accept(this.timer);
    }

    public void teleport() {
        AbstractLocation location = this.getLocation();
        if (location == null || this.castTracker.isHasEnded()) {
            this.terminate();
        } else {
            this.castHologram.teleport(this.getLocation());
            this.nameHologram.teleport(this.getLocation().add(0.0, 0.25, 0.0));
        }
    }

    public void setInterrupted() {
        this.timer.terminate();
        this.castHologram.setText(ColorString.get("&c[Interrupted]"));
    }

    public void setFinished() {
        this.timer.terminate();
        this.castHologram.setText(ColorString.get("&a[Casted!]"));
    }

    @Override
    public void close() {
        Schedulers.sync().runLater(() -> this.components.terminate(), 10L);
    }

    private AbstractLocation getLocation() {
        return this.skillCaster.getEntity().getEyeLocation().add(0.0, this.yOffset, 0.0);
    }

    public void setCastPercent(double percent) {
        this.castPercent = percent;
        this.castHologram.setText(this.getCastBar());
    }

    private String getCastBar() {
        int length = 30;
        int gray = (int)Math.floor(this.castPercent * 30.0);
        StringBuilder line = new StringBuilder();
        boolean passed = false;
        for (int i = 30; i > 0; --i) {
            if (!passed && i < gray) {
                passed = true;
            }
            line.append(passed ? ChatColor.DARK_GRAY : ChatColor.AQUA);
            line.append("|");
        }
        return line.toString();
    }
}

