/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.logging;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropTable;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawner;
import io.lumine.xikage.mythicmobs.utils.logging.ConsoleColor;
import java.io.File;
import java.io.PrintWriter;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class MythicLogger {
    public static void log(String message) {
        MythicMobs.inst().getLogger().log(Level.INFO, message + (Object)((Object)ConsoleColor.RESET));
    }

    public static void log(String message, Object ... params) {
        MythicMobs.inst().getLogger().log(Level.INFO, message + (Object)((Object)ConsoleColor.RESET), params);
    }

    public static void log(Level level, String message) {
        MythicMobs.inst().getLogger().log(level, message + (Object)((Object)ConsoleColor.RESET));
    }

    public static void log(Level level, String message, Object ... params) {
        MythicMobs.inst().getLogger().log(level, message + (Object)((Object)ConsoleColor.RESET), params);
    }

    public static void error(String message) {
        MythicLogger.log(Level.WARNING, message + (Object)((Object)ConsoleColor.RESET));
    }

    public static void error(String message, Object ... params) {
        MythicLogger.log(Level.WARNING, message + (Object)((Object)ConsoleColor.RESET), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex) {
        MythicLogger.log(Level.SEVERE, message + (Object)((Object)ConsoleColor.RESET));
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (ConfigManager.debugLevel > 0) {
            ex.printStackTrace();
        }
        if (ConfigManager.errorLogging) {
            try (PrintWriter writer = null;){
                File folder = new File(MythicMobs.inst().getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    t.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the Error Logs folder. Please report it on the MythicCraft forums or discord.");
                writer.println("MythicMobs version: " + MythicMobs.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex, Object ... params) {
        MythicLogger.log(Level.SEVERE, message + (Object)((Object)ConsoleColor.RESET), params);
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (ConfigManager.debugLevel > 0) {
            ex.printStackTrace();
        }
        if (ConfigManager.errorLogging) {
            try (PrintWriter writer = null;){
                File folder = new File(MythicMobs.inst().getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    t.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the Error Logs folder. Please report it on the MythicCraft forums or discord.");
                writer.println("MythicMobs version: " + MythicMobs.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    public static void errorGenericConfig(String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error: " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorGenericConfig(MythicLineConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " LineConfig Error: " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorConditionConfig(SkillCondition condition, MythicLineConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for Condition line '" + (Object)((Object)ConsoleColor.UNDERLINE) + config.getLine() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorDropConfig(Drop drop, MythicLineConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for Drop '" + (Object)((Object)ConsoleColor.UNDERLINE) + drop.getLine() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "' in '" + config.getFileName() + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorDropTableConfig(DropTable drop, MythicLineConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for DropTable '" + (Object)((Object)ConsoleColor.UNDERLINE) + drop.getInternalName() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "' in '" + config.getFileName() + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorEntityConfig(BukkitEntityType entity, MythicConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for Mob '" + (Object)((Object)ConsoleColor.UNDERLINE) + config.getKey() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "' in '" + config.getFile().getName() + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorItemConfig(MythicItem item, MythicConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for Item '" + (Object)((Object)ConsoleColor.UNDERLINE) + config.getKey() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "' in '" + config.getFile().getName() + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorMechanicConfig(SkillMechanic mechanic, MythicLineConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for Mechanic line '" + (Object)((Object)ConsoleColor.UNDERLINE) + config.getLine() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "' in '" + config.getFileName() + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorMobConfig(MythicMob mob, MythicConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for Mob '" + (Object)((Object)ConsoleColor.UNDERLINE) + config.getKey() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "' in '" + config.getFile().getName() + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorTargeterConfig(SkillTargeter targeter, MythicLineConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for Targeter line '" + (Object)((Object)ConsoleColor.UNDERLINE) + config.getLine() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorSpawnConfig(RandomSpawner spawner, MythicConfig config, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Config Error for RandomSpawn '" + (Object)((Object)ConsoleColor.UNDERLINE) + config.getKey() + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "' in '" + config.getFile().getName() + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorCompatibility(String plugin, String error) {
        MythicLogger.error("" + (Object)((Object)ConsoleColor.ERROR_MARK) + (Object)((Object)ConsoleColor.YELLOW) + " Compatibility Error for '" + (Object)((Object)ConsoleColor.UNDERLINE) + plugin + (Object)((Object)ConsoleColor.RESET) + (Object)((Object)ConsoleColor.YELLOW) + "': " + (Object)((Object)ConsoleColor.WHITE) + error);
    }

    public static void debug(DebugLevel level, String message, Object ... params) {
        if (ConfigManager.debugLevel == 0) {
            return;
        }
        if (ConfigManager.debugLevel < level.ordinal()) {
            return;
        }
        switch (level) {
            case INFO: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.CYAN) + "[i] " + message, params);
                return;
            }
            case SKILL: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.PURPLE) + "+--- " + (Object)((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case SKILL_CHECK: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.PURPLE) + "|----- " + (Object)((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case SKILL_INFO: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.PURPLE) + "|------- " + (Object)((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case MECHANIC: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.PURPLE) + "~----------- " + (Object)((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case CONDITION: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.PURPLE) + "|--------? " + (Object)((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case TRIGGER: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.PURPLE) + "#- " + (Object)((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case EVENT: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.CYAN) + "[e] " + message, params);
                return;
            }
            case CLOCK: {
                MythicLogger.log(Level.INFO, (Object)((Object)ConsoleColor.CYAN) + "[c] " + message, params);
                return;
            }
        }
    }

    private MythicLogger() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static enum DebugLevel {
        NONE,
        INFO,
        SKILL,
        SKILL_CHECK,
        SKILL_INFO,
        MECHANIC,
        CONDITION,
        TRIGGER,
        EVENT,
        CLOCK;

    }
}

