/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.LinkedList;
import java.util.Queue;

public class MythicMobStack
implements Comparable<MythicMobStack> {
    private String internalName;
    private String stackString;
    private String file;
    private MythicMob base;
    private Queue<MythicMob> stack = new LinkedList<MythicMob>();
    private boolean enabled = true;

    public MythicMobStack(String name, String stackString, String file) {
        this.internalName = name;
        this.stackString = stackString;
        this.file = file;
        String[] part = this.stackString.split(",");
        MythicMob mm3 = MythicMobs.inst().getMobManager().getMythicMob(part[0]);
        if (mm3 == null) {
            MythicLogger.error("Could not load MythicMobStack {0}! Invalid type(s) specified.", this.internalName);
            this.stack.clear();
            this.enabled = false;
            return;
        }
        this.base = mm3;
        for (int i = 1; i < part.length; ++i) {
            mm3 = MythicMobs.inst().getMobManager().getMythicMob(part[i]);
            if (mm3 == null) {
                MythicLogger.error("Could not load MythicMobStack {0}! Invalid type(s) specified.", this.internalName);
                this.stack.clear();
                this.enabled = false;
                return;
            }
            this.stack.add(mm3);
        }
    }

    public boolean isValid() {
        return this.enabled;
    }

    public String getName() {
        return this.internalName;
    }

    public String getFile() {
        return this.file;
    }

    public String getStackString() {
        return this.stackString;
    }

    public ActiveMob spawn(AbstractLocation l, double level, SpawnReason reason) {
        if (!this.enabled) {
            return null;
        }
        ActiveMob base = this.base.spawn(l, level, reason);
        AbstractEntity f = base.getEntity();
        for (MythicMob mm3 : this.stack) {
            AbstractEntity e = mm3.spawn(l, level, SpawnReason.SUMMON).getEntity();
            f.setPassenger(e);
            f = e;
        }
        return base;
    }

    @Override
    public int compareTo(MythicMobStack o) {
        return this.internalName.compareTo(o.getName());
    }
}

