/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillHelper;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.conditions.ConditionAction;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.targeters.ConsoleTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.CustomTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.skills.targeters.OriginTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.TriggerLocationTargeter;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;

public abstract class AbstractSkill {
    protected boolean ASYNC_SAFE = true;
    public static long cooldownTimer = 0L;
    protected UUID uuid;
    protected float cooldown = 0.0f;
    protected float power = 0.0f;
    protected float powerScale = 1.0f;
    protected PlaceholderInt delay = PlaceholderInt.of("0");
    protected PlaceholderInt repeat = PlaceholderInt.of("0");
    protected PlaceholderInt repeatInterval = PlaceholderInt.of("0");
    protected float chance = 1.0f;
    protected String healthMod = null;
    protected boolean powerSplitBetweenTargets = false;
    protected SkillTrigger trigger = SkillTrigger.COMBAT;
    protected boolean sourceIsOrigin = false;
    protected HashMap<UUID, Long> cooldowns = new HashMap();
    protected Optional<SkillTargeter> targeter = Optional.empty();
    protected boolean target_creative = false;
    protected List<SkillCondition> conditions = null;
    protected List<SkillCondition> conditionsTarget = null;
    protected List<SkillCondition> conditionsTrigger = null;

    public static MythicMobs getPlugin() {
        return MythicMobs.inst();
    }

    public AbstractSkill() {
        this.uuid = UUID.randomUUID();
    }

    public boolean onCooldown(SkillCaster skillCaster) {
        if (this.cooldown == 0.0f) {
            return false;
        }
        long next = this.cooldowns.getOrDefault(skillCaster.getEntity().getUniqueId(), 0L);
        return next >= cooldownTimer;
    }

    public float getCooldown(SkillCaster skillCaster) {
        if (this.cooldown == 0.0f) {
            return 0.0f;
        }
        long next = this.cooldowns.getOrDefault(skillCaster.getEntity().getUniqueId(), 0L);
        if (next < cooldownTimer) {
            return 0.0f;
        }
        return (next - cooldownTimer) / 20L;
    }

    public void setCooldown(SkillCaster skillCaster, float cooldown) {
        if (cooldown > 0.0f) {
            this.cooldowns.put(skillCaster.getEntity().getUniqueId(), (long)((float)cooldownTimer + cooldown * 20.0f - 2.0f));
        } else {
            this.cooldowns.remove(skillCaster.getEntity().getUniqueId());
        }
    }

    protected boolean rollChance() {
        if (this.chance == 1.0f) {
            return true;
        }
        return !(Numbers.randomDouble() > (double)this.chance);
    }

    protected boolean checkHealth(SkillCaster skillCaster) {
        String[] healthparts;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Performing Health Check", new Object[0]);
        if (this.healthMod == null) {
            return true;
        }
        String[] stringArray = healthparts = this.healthMod.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            double bosshp;
            String health;
            String healthT = health = stringArray[i];
            String skillstr = skillCaster.getEntity().getUniqueId() + this.uuid.toString() + "#" + health;
            healthT = healthT.replace("%", "");
            healthT = healthT.replace("<", "");
            healthT = healthT.replace(">", "");
            healthT = healthT.replace("=", "");
            if (!(healthT = healthT.replace("-", "")).matches("[-+]?[0-9]*.?[0-9]+")) {
                return true;
            }
            double hp = Double.parseDouble(healthT);
            if (health.endsWith("%")) {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / 100.0;
            } else {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / skillCaster.getEntity().getMaxHealth();
            }
            if (health.startsWith(">")) {
                health = health.replace(">", "");
                if (!(bosshp > hp)) continue;
                return true;
            }
            if (health.startsWith("<")) {
                health = health.replace("<", "");
                if (!(bosshp < hp)) continue;
                return true;
            }
            if (health.startsWith("=")) {
                if ((health = health.replace("=", "")).contains("-")) {
                    String[] hps = health.split("-");
                    double hp1 = hps[0].endsWith("%") ? Double.parseDouble(hps[0].substring(0, hps[0].length() - 1)) / 100.0 : Double.parseDouble(hps[0].substring(0, hps[0].length())) / skillCaster.getEntity().getMaxHealth();
                    double hp2 = hps[1].endsWith("%") ? Double.parseDouble(hps[1].substring(0, hps[1].length() - 1)) / 100.0 : Double.parseDouble(hps[1].substring(0, hps[1].length())) / skillCaster.getEntity().getMaxHealth();
                    if (hp2 > hp1) {
                        double hp3 = hp1;
                        hp1 = hp2;
                        hp2 = hp3;
                    }
                    if (!(bosshp > hp2) || !(bosshp < hp1)) continue;
                    return true;
                }
                if (!(bosshp <= hp) || !(skillCaster.getEntity().getHealth() > hp) || SkillHelper.hasUsedSkill(skillstr, skillCaster.getEntity())) continue;
                if (skillCaster instanceof ActiveMob && !((ActiveMob)skillCaster).getType().getRepeatAllSkills().booleanValue()) {
                    MythicMobs.inst().getMobManager();
                    MobManager.setMetaData(skillCaster.getEntity(), skillstr, skillstr);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean checkSkillTrigger(SkillTrigger trigger) {
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", new Object[]{trigger, this.trigger});
        if (trigger.equals((Object)SkillTrigger.SIGNAL)) {
            return true;
        }
        switch (this.trigger) {
            case TIMER: {
                return true;
            }
            case API: {
                return true;
            }
            case SIGNAL: {
                return true;
            }
            case COMBAT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK;
            }
            case KILL: {
                return trigger == SkillTrigger.KILL || trigger == SkillTrigger.KILLPLAYER;
            }
            case DEFAULT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK || trigger == SkillTrigger.SPAWN || trigger == SkillTrigger.DEATH || trigger == SkillTrigger.TIMER;
            }
        }
        return this.trigger.equals((Object)trigger);
    }

    protected boolean checkSkillTrigger(SkillMetadata meta) {
        SkillTrigger trigger = meta.getCause();
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", new Object[]{trigger, this.trigger});
        if (trigger.equals((Object)SkillTrigger.SIGNAL)) {
            return true;
        }
        switch (this.trigger) {
            case TIMER: {
                return true;
            }
            case API: {
                return true;
            }
            case SIGNAL: {
                return true;
            }
            case COMBAT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK;
            }
            case KILL: {
                return trigger == SkillTrigger.KILL || trigger == SkillTrigger.KILLPLAYER;
            }
            case DEFAULT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK || trigger == SkillTrigger.SPAWN || trigger == SkillTrigger.DEATH || trigger == SkillTrigger.TIMER;
            }
        }
        return this.trigger.equals((Object)trigger);
    }

    protected SkillTrigger parseSkillTrigger(String strTrigger) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTrigger {0}", strTrigger);
        String search = strTrigger.substring(3).toUpperCase();
        if (search.contains("TIMER")) {
            return SkillTrigger.TIMER;
        }
        switch (search) {
            case "SPAWN": {
                return SkillTrigger.SPAWN;
            }
            case "DEATH": {
                return SkillTrigger.DEATH;
            }
            case "DESPAWN": 
            case "DESPAWNED": {
                return SkillTrigger.DESPAWNED;
            }
            case "COMBAT": {
                return SkillTrigger.COMBAT;
            }
            case "DAMAGED": 
            case "HURT": {
                return SkillTrigger.DAMAGED;
            }
            case "ATTACK": 
            case "HIT": {
                return SkillTrigger.ATTACK;
            }
            case "EXPLODE": {
                return SkillTrigger.EXPLODE;
            }
            case "TELEPORT": {
                return SkillTrigger.TELEPORT;
            }
            case "KILL": {
                return SkillTrigger.KILL;
            }
            case "KILLPLAYER": 
            case "PLAYERKILL": {
                return SkillTrigger.KILLPLAYER;
            }
            case "PLAYERDEATH": 
            case "PLAYERDIE": {
                return SkillTrigger.PLAYERDEATH;
            }
            case "ENTERCOMBAT": {
                return SkillTrigger.ENTERCOMBAT;
            }
            case "COMBATDROP": 
            case "DROPCOMBAT": 
            case "LEAVECOMBAT": {
                return SkillTrigger.DROPCOMBAT;
            }
            case "CHANGETARGET": 
            case "TARGETCHANGE": {
                return SkillTrigger.TARGETCHANGE;
            }
            case "INTERACT": {
                return SkillTrigger.INTERACT;
            }
            case "READY": 
            case "FIRSTSPAWN": {
                return SkillTrigger.READY;
            }
            case "SWING": 
            case "LEFTCLICK": {
                return SkillTrigger.SWING;
            }
            case "RIGHTCLICK": {
                return SkillTrigger.RIGHTCLICK;
            }
            case "USE": {
                return SkillTrigger.USE;
            }
            case "SHOOT": 
            case "BOWSHOOT": 
            case "SHOOTBOW": {
                return SkillTrigger.SHOOT;
            }
            case "BOWHIT": {
                return SkillTrigger.BOW_HIT;
            }
            case "CONSUME": 
            case "EAT": {
                return SkillTrigger.CONSUME;
            }
            case "POTIONSPLASH": 
            case "SPLASHPOTION": {
                return SkillTrigger.SPLASH_POTION;
            }
            case "CROUCH": {
                return SkillTrigger.CROUCH;
            }
            case "UNCROUCH": {
                return SkillTrigger.UNCROUCH;
            }
            case "BLOCK": {
                return SkillTrigger.BLOCK;
            }
            case "BLOCKBREAK": 
            case "BREAKBLOCK": {
                return SkillTrigger.BLOCK_BREAK;
            }
            case "BLOCKPLACE": 
            case "PLACEBLOCK": {
                return SkillTrigger.BLOCK_PLACE;
            }
            case "EQUIP": 
            case "EQUIPARMOR": 
            case "ARMOREQUIP": {
                return SkillTrigger.ARMOR_EQUIP;
            }
            case "UNEQUIP": 
            case "UNEQUIPARMOR": 
            case "ARMORUNEQUIP": {
                return SkillTrigger.ARMOR_UNEQUIP;
            }
            case "FISH": 
            case "FISHING": 
            case "FISHINGCAST": {
                return SkillTrigger.FISH;
            }
            case "FISHBITE": 
            case "FISHINGBITE": {
                return SkillTrigger.FISH_BITE;
            }
            case "FISHCATCH": 
            case "FISHCAUGHT": 
            case "FISHINGCATCH": 
            case "FISHINGCAUGHT": 
            case "CATCHFISH": 
            case "CAUGHTFISH": {
                return SkillTrigger.FISH_CATCH_FISH;
            }
            case "FISHGRAB": 
            case "FISHINGGRAB": 
            case "FISHENTITY": 
            case "FISHINGENTITY": {
                return SkillTrigger.FISH_CATCH_ENTITY;
            }
            case "FISHGROUND": 
            case "FISHINGGROUND": {
                return SkillTrigger.FISH_GROUND;
            }
            case "FISHREEL": 
            case "FISHINGREEL": {
                return SkillTrigger.FISH_REEL;
            }
            case "FISHFAIL": 
            case "FISHINGFAIL": {
                return SkillTrigger.FISH_FAIL;
            }
            case "TRIDENTHIT": {
                return SkillTrigger.TRIDENT_HIT;
            }
            case "THROWTRIDENT": 
            case "TRIDENTTHROW": {
                return SkillTrigger.TRIDENT_THROW;
            }
        }
        return SkillTrigger.DEFAULT;
    }

    protected SkillTargeter parseSkillTargeter(String strTarget) {
        String search = strTarget.substring(1);
        MythicLineConfig mlc = new MythicLineConfig(search);
        String name = search.contains("{") ? search.substring(0, search.indexOf("{")) : search;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTargeter {0}", search);
        return SkillTargeter.getMythicTargeter(name, mlc);
    }

    protected SkillCondition parseSkillCondition(String strCondition) {
        String search = strCondition.substring(1);
        boolean n = false;
        if (search.substring(1).equals("!")) {
            search = strCondition.substring(1);
            n = true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillCondition {0}", search);
        SkillCondition cond = SkillCondition.getCondition(search);
        if (cond != null && n) {
            cond.setAction(ConditionAction.FALSE);
        }
        return cond;
    }

    public void setTargetsCreativePlayers(boolean b) {
        this.target_creative = b;
    }

    public boolean targetsCreativePlayers() {
        return this.target_creative;
    }

    public SkillMetadata evaluateTargets(SkillMetadata data) {
        if (this.targeter.isPresent()) {
            SkillTargeter targeter = this.targeter.get();
            if (targeter instanceof CustomTargeter && ((CustomTargeter)targeter).getTargeter().isPresent()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillTargeter is a CUSTOM targeter", new Object[0]);
                targeter = ((CustomTargeter)targeter).getTargeter().get();
            }
            if (targeter instanceof IEntitySelector) {
                try {
                    data.setEntityTargets(((IEntitySelector)targeter).getEntities(data));
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": EntityTargeter found {0} targets", data.getEntityTargets().size());
                    ((IEntitySelector)targeter).filter(data, this.targetsCreativePlayers());
                }
                catch (IllegalArgumentException ex) {
                    data.setEntityTargets(Sets.newHashSet());
                }
            }
            if (targeter instanceof ILocationSelector) {
                data.setLocationTargets(((ILocationSelector)targeter).getLocations(data));
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": LocationTargeter found {0} targets", data.getLocationTargets().size());
                ((ILocationSelector)targeter).filter(data);
            } else if (targeter instanceof OriginTargeter) {
                data.setLocationTargets(((OriginTargeter)targeter).getLocation(data.getOrigin()));
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting origin", new Object[0]);
            } else if (targeter instanceof TriggerLocationTargeter) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting trigger location", new Object[0]);
                HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
                lTargets.add(data.getTrigger().getLocation());
                data.setLocationTargets(lTargets);
            }
            if (targeter instanceof ConsoleTargeter) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting console", new Object[0]);
                data.setEntityTargets(null);
                data.setLocationTargets(null);
            }
        }
        if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0 && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getEntityTargets().size());
        }
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0 && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getLocationTargets().size());
        }
        return data;
    }

    public SkillTrigger getTrigger() {
        return this.trigger;
    }

    public Optional<SkillTargeter> getTargeter() {
        return this.targeter;
    }

    public List<SkillCondition> getConditions() {
        return this.conditions;
    }

    public List<SkillCondition> getConditionsTarget() {
        return this.conditionsTarget;
    }

    public List<SkillCondition> getConditionsTrigger() {
        return this.conditionsTrigger;
    }

    protected static class DelayedSkill
    implements Runnable {
        private SkillMetadata data;
        private Queue<SkillMechanic> skills;
        private boolean cancelled;

        public DelayedSkill(SkillMetadata data, Queue<SkillMechanic> skills) {
            this.data = data;
            this.skills = skills;
            this.cancelled = false;
        }

        public void cancel() {
            this.skills = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                block4: {
                    try {
                        if (this.data.getCaster().getEntity().isDead() && !this.data.getCause().equals((Object)SkillTrigger.DEATH) && !this.data.getCause().equals((Object)SkillTrigger.DESPAWNED) && !this.data.getCause().equals((Object)SkillTrigger.EXPLODE)) {
                            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Mob is dead, cancelling skill (cause = {0})", new Object[]{this.data.getCause()});
                            this.cancel();
                            return;
                        }
                        Skill.execute(this.data, this.skills);
                    }
                    catch (NullPointerException ex) {
                        this.cancel();
                        AbstractSkill.getPlugin().getConfiguration();
                        if (ConfigManager.debugLevel <= 0) break block4;
                        ex.printStackTrace();
                    }
                }
                return;
            }
        }
    }
}

