/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import java.util.HashSet;
import java.util.Set;

@MythicCondition(author="Ashijin", name="mythicMobType", aliases={"mmType"}, description="Checks the MythicMob type of the target mob")
public class MythicMobTypeCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="type", aliases={"types", "t"}, description="A list of MythicMob types")
    private Set<String> types = new HashSet<String>();

    public MythicMobTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String[] split;
        String types = mlc.getString(new String[]{"types", "type", "t"}, this.conditionVar, new String[0]);
        for (String s2 : split = types.split(",")) {
            this.types.add(s2);
        }
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (MythicMobs.inst().getMobManager().isActiveMob(entity)) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(entity);
            return this.types.contains(am.getType().getInternalName());
        }
        return false;
    }
}

