/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.variables.VariableCondition;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;

@MythicCondition(author="Ashijin", name="variableIsSet", aliases={"varisset", "varset"}, version="4.6", description="Checks if the given variable is set.")
public class VariableIsSetCondition
extends VariableCondition
implements IEntityCondition,
ILocationCondition,
ISkillMetaCondition {
    public VariableIsSetCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
    }

    @Override
    public boolean check(AbstractEntity target) {
        VariableRegistry registry = VariableIsSetCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        try {
            return registry.has(this.key);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableIsSet condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(AbstractLocation target) {
        VariableRegistry registry = VariableIsSetCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        try {
            return registry.has(this.key);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableIsSet condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(SkillMetadata meta) {
        VariableRegistry registry = VariableIsSetCondition.getPlugin().getVariableManager().getRegistry(this.scope, meta, meta.getCaster().getEntity());
        try {
            return registry.has(this.key);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableIsSet condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

