/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.damage.DamagingMechanic;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="baseDamage", aliases={"bd", "weaponDamage", "wd"}, description="Deals a percent of the mob's damage stat as damage")
public class BaseDamageMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    protected double multiplier;

    public BaseDamageMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.multiplier = mlc.getDouble(new String[]{"multiplier", "m"}, 1.0);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        SkillCaster caster = data.getCaster();
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            if (am.isUsingDamageSkill()) {
                return false;
            }
            double damage = am.getDamage() * this.multiplier * (double)data.getPower();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ BaseDamageMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
            this.doDamage(data.getCaster(), target, damage);
        } else {
            double damage = this.multiplier * (double)data.getPower();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ BaseDamageMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
            this.doDamage(data.getCaster(), target, damage);
        }
        return true;
    }
}

