/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import java.util.Optional;

@MythicMechanic(author="Ashijin", version="4.8", name="blackScreen", aliases={"effect:blackScreen", "e:blackScreen"}, description="Causes the player's screen to black out")
public class BlackScreenEffect
extends Aura
implements ITargetedEntitySkill {
    private static final AbstractLocation LOCATION = new AbstractLocation(null, 99999.0, 0.0, 99999.0);
    @MythicField(name="duration", aliases={"d"}, version="4.8", description="How long the effect should last")
    private int duration;
    @MythicField(name="cancel", aliases={"c"}, version="4.8", description="If true, will cancel any existing effects immediately")
    private boolean cancel;

    public BlackScreenEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.auraName = Optional.of("#blackScreen");
        this.maxStacks = PlaceholderInt.of("1");
        this.refreshDuration = true;
        this.interval = PlaceholderInt.of("10");
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            new BlackScreenEffectTracker(target, data);
        }
        return true;
    }

    public class BlackScreenEffectTracker
    extends Aura.AuraTracker {
        public BlackScreenEffectTracker(AbstractEntity target, SkillMetadata data) {
            super((Aura)BlackScreenEffect.this, target, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.executeAuraSkill(BlackScreenEffect.this.onStartSkill, this.skillMetadata);
            AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().forcePlayCredits(((AbstractEntity)this.entity.get()).asPlayer(), 1.0f);
        }

        @Override
        public void auraTick() {
            AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().forcePlayCredits(((AbstractEntity)this.entity.get()).asPlayer(), 1.0f);
            this.executeAuraSkill(BlackScreenEffect.this.onTickSkill, this.skillMetadata);
        }

        @Override
        public void auraStop() {
            AbstractSkill.getPlugin().getVolatileCodeHandler().getEntityHandler().forceCloseWindow(((AbstractEntity)this.entity.get()).asPlayer());
            this.executeAuraSkill(BlackScreenEffect.this.onEndSkill, this.skillMetadata);
        }
    }
}

