/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;

@MythicMechanic(author="Ashijin", name="blockWave", aliases={"effect:blockWave", "e:blockWave"}, description="Temporarily masks a block as a different block")
public class BlockWaveEffect
extends SkillMechanic
implements ITargetedLocationSkill {
    protected PlaceholderDouble velocity;
    protected PlaceholderDouble velocityH;
    protected int radius;
    protected int radiusY;
    protected int duration;
    protected double randomness;
    protected boolean sphere;
    protected Material material;
    protected boolean hideSourceBlock;
    private int radiusSq;

    public BlockWaveEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.velocity = mlc.getPlaceholderDouble(new String[]{"velocity", "v"}, 0.2, new String[0]);
        this.velocityH = mlc.getPlaceholderDouble(new String[]{"horizontalvelocity", "velocityh", "vh"}, 0.0, new String[0]);
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 2);
        this.radiusY = mlc.getInteger(new String[]{"radiusy", "ry"}, this.radius);
        this.randomness = mlc.getDouble(new String[]{"noise", "n"}, 0.0);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 15);
        this.hideSourceBlock = mlc.getBoolean(new String[]{"hidesourceblock", "hidesource", "hsb", "hs"}, true);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        String strMaterial = mlc.getString(new String[]{"material", "m"}, null, new String[0]);
        this.material = strMaterial == null ? null : Material.valueOf((String)strMaterial.toUpperCase());
        if (this.radius < 0) {
            this.radius = 0;
        }
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        double bv = this.velocity.get(data);
        double bvh = this.velocityH.get(data);
        if (this.radius == 0) {
            double v = -(bv / 2.0) + bv * Numbers.randomDouble();
            double vh = -(bvh / 2.0) + bvh * Numbers.randomDouble();
            BlockWaveEffect.getPlugin().getVolatileCodeHandler().getWorldHandler().doBlockTossEffect(target, this.material, new AbstractVector(vh, v, vh), this.duration, this.hideSourceBlock);
        } else {
            for (AbstractLocation l : this.getBlocksInRadius(target, true)) {
                double v = -(bv / 2.0) + bv * Numbers.randomDouble();
                double vh = -(bvh / 2.0) + bvh * Numbers.randomDouble();
                BlockWaveEffect.getPlugin().getVolatileCodeHandler().getWorldHandler().doBlockTossEffect(l, this.material, new AbstractVector(vh, v, vh), this.duration, this.hideSourceBlock);
            }
        }
        return true;
    }

    private List<AbstractLocation> getBlocksInRadius(AbstractLocation location, boolean randomize) {
        ArrayList<AbstractLocation> blocks = new ArrayList<AbstractLocation>();
        Location loc = BukkitAdapter.adapt(location);
        for (int x = -this.radius; x <= this.radius; ++x) {
            block1: for (int z = -this.radius; z <= this.radius; ++z) {
                for (int y = this.radiusY; y >= -this.radiusY; --y) {
                    Location newloc = new Location(loc.getWorld(), (double)(loc.getBlockX() + x), (double)(loc.getBlockY() + y), (double)(loc.getBlockZ() + z));
                    if (this.sphere && loc.distanceSquared(newloc) > (double)this.radiusSq || randomize && this.randomness > 0.0 && this.randomness < Numbers.randomDouble() || newloc.getBlock().getType() == Material.AIR) continue;
                    blocks.add(BukkitAdapter.adapt(newloc));
                    continue block1;
                }
            }
        }
        return blocks;
    }
}

