/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="doppleganger", aliases={"copyplayer"}, description="Disguises the caster as the target entity")
public class DopplegangerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private boolean hasNameplate;
    private boolean usePlayerName;

    public DopplegangerMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.hasNameplate = mlc.getBoolean(new String[]{"hasnameplate", "nameplate"}, true);
        this.usePlayerName = mlc.getBoolean(new String[]{"useplayername", "upn"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        if (CompatibilityManager.LibsDisguises == null) {
            return false;
        }
        if (!target.isPlayer()) {
            return false;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        String disguise = !this.hasNameplate ? "doppleganger::" + target.asPlayer().getName() : (this.usePlayerName ? "doppleganger:" + target.asPlayer().getName() + ":" + target.asPlayer().getName() : (am.getType().getDisplayName() == null ? "doppleganger:_:" + target.asPlayer().getName() : "doppleganger:" + am.getType().getDisplayName().get(data, target) + ":" + target.asPlayer().getName()));
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "[+] Running Doppleganger AbstractSkill with string: " + disguise, new Object[0]);
        CompatibilityManager.LibsDisguises.setDisguise(am, disguise, true);
        return true;
    }
}

