/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

@MythicMechanic(author="Ashijin", name="enderDragonGeneratePortal", aliases={"generateEnderDragonPortal"}, description="Generates the EnderDragon portal")
public class EnderDragonSetPhaseMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private EnderDragon.Phase phase = EnderDragon.Phase.CIRCLING;

    public EnderDragonSetPhaseMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        String strPhase = mlc.getString(new String[]{"phase", "p"}, "CIRCLING", new String[0]).toUpperCase();
        try {
            this.phase = EnderDragon.Phase.valueOf((String)strPhase);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid phase supplied");
            this.phase = EnderDragon.Phase.CIRCLING;
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof EnderDragon)) {
            return false;
        }
        EnderDragon dragon = (EnderDragon)entity;
        dragon.setPhase(this.phase);
        return true;
    }
}

