/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.sk89q.worldedit.extent.clipboard.Clipboard;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;
import io.lumine.xikage.mythicmobs.utils.worldedit.Regions;
import java.io.File;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="fawePaste", aliases={}, premium=true, version="4.11", description="Pastes a schematic using Fawe")
public class FawePasteMechanic
extends SkillMechanic
implements ITargetedLocationSkill {
    private PlaceholderString schematicName;
    private boolean ignoreAir;
    private int x;
    private int y;
    private int z;

    public FawePasteMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        if (!MythicMobs.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, mlc, "fawePaste mechanic requires Mythic Premium");
            return;
        }
        this.schematicName = mlc.getPlaceholderString(new String[]{"schematic", "s"}, null, new String[0]);
        this.ignoreAir = !mlc.getBoolean(new String[]{"pasteair", "air", "a"}, false);
        this.x = mlc.getInteger(new String[]{"xoffset", "xo", "x"}, 0);
        this.y = mlc.getInteger(new String[]{"yoffset", "yo", "y"}, 0);
        this.z = mlc.getInteger(new String[]{"zoffset", "zo", "z"}, 0);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (!MythicMobs.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "fawePaste mechanic requires Mythic Premium");
            return false;
        }
        String schematic = this.schematicName.get(data);
        File schematicFolder = new File(FawePasteMechanic.getPlugin().getDataFolder(), "Schematics");
        File schematicFile = new File(schematicFolder, schematic);
        if (!schematicFile.exists()) {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not find schematic file " + schematicFile.getAbsolutePath());
            return false;
        }
        Optional<Clipboard> maybeClipboard = Regions.loadSchematic(schematicFile);
        if (!maybeClipboard.isPresent()) {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not load schematic");
            return false;
        }
        Clipboard clipboard = maybeClipboard.get();
        Position position = target.toPosition();
        position = position.subtract(clipboard.getRegion().getWidth() / 2, clipboard.getRegion().getHeight() / 2, clipboard.getRegion().getLength() / 2);
        position = position.add(this.x, this.y, this.z);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Pasting schematic at {0}", position.toString());
        Regions.pasteSchematic(clipboard, position, this.ignoreAir);
        return true;
    }
}

