/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="feed", description="Feeds the target entity")
public class FeedSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderInt amount;
    protected float saturation;
    protected boolean overfeed;

    public FeedSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        this.saturation = mlc.getFloat(new String[]{"saturation", "s"}, 0.0f);
        this.overfeed = mlc.getBoolean(new String[]{"overfeed", "of", "o"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || !target.isPlayer()) {
            return false;
        }
        int currentFood = target.asPlayer().getFoodLevel();
        int food = currentFood + this.amount.get(data, target);
        float saturation = target.asPlayer().getFoodSaturation() + this.saturation;
        if (food >= 20) {
            if (this.overfeed) {
                target.asPlayer().setFoodLevel(food);
                if (saturation > (float)food) {
                    saturation = food;
                }
            } else {
                target.asPlayer().setFoodLevel(20);
                if (saturation > 20.0f) {
                    saturation = 20.0f;
                }
            }
        } else {
            target.asPlayer().setFoodLevel(food);
            if (!this.overfeed && saturation > (float)food) {
                saturation = food;
            }
        }
        target.asPlayer().setFoodSaturation(saturation);
        return true;
    }
}

