/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="forcepull", description="Teleports the target entity to the caster")
public class ForcePullMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected float spread;
    protected float spreadV;

    public ForcePullMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.spread = mlc.getFloat(new String[]{"spread", "s"}, 0.0f);
        this.spreadV = mlc.getFloat(new String[]{"vspread", "vs"}, this.spread);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.spread > 0.0f) {
            AbstractLocation location = this.sourceIsOrigin ? data.getCaster().getLocation() : data.getOrigin();
            location = MobManager.findSafeSpawnLocation(location, (int)this.spread, (int)this.spreadV, 1);
            target.teleport(location);
        } else {
            target.teleport(this.sourceIsOrigin ? data.getOrigin() : data.getCaster().getLocation());
        }
        return true;
    }
}

