/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="healpercent", aliases={"percentheal", "hp"}, description="Heals the target entity for a percentage of their health")
public class HealPercentMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble multiplier;
    protected boolean overheal;
    protected PlaceholderDouble maxOverheal;

    public HealPercentMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.multiplier = mlc.getPlaceholderDouble(new String[]{"multiplier", "m"}, 0.1, new String[0]);
        this.overheal = mlc.getBoolean("overheal", false);
        this.maxOverheal = mlc.getPlaceholderDouble(new String[]{"maxoverheal", "maxabsorb", "maxshield", "mo", "ma", "ms"}, 0.0, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return false;
        }
        double heal = target.getMaxHealth() * this.multiplier.get(data, target);
        double health = target.getHealth() + heal;
        if (health >= target.getMaxHealth()) {
            if (this.overheal) {
                double max = target.getMaxHealth() * this.maxOverheal.get(data, target);
                double diff = health - target.getMaxHealth();
                double absorb = (double)MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().getEntityAbsorptionHearts(target) + diff;
                if (absorb < max) {
                    MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().setEntityAbsorptionHearts(target, (float)absorb);
                }
            }
            target.setHealth(target.getMaxHealth());
        } else {
            if (health < 0.0) {
                health = 0.0;
            }
            target.setHealth(health);
        }
        return true;
    }
}

