/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="messagejson", aliases={"jsonmessage", "jmsg", "jm"}, description="Sends a JSON-formatted message to the target entity")
public class MessageJSONMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected PlaceholderString message;

    public MessageJSONMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        try {
            this.message = mlc.getPlaceholderString(new String[]{"message", "msg", "m"}, null, new String[0]);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.message = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            ex.printStackTrace();
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded message skill with message " + this.message, new Object[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing message skill with message: " + this.message, new Object[0]);
        if (target.isPlayer()) {
            String m3 = this.message.get(data, target);
            BaseComponent[] message = ComponentSerializer.parse((String)m3);
            ((Player)target.getBukkitEntity()).spigot().sendMessage(message);
            return true;
        }
        return false;
    }
}

