/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

@MythicMechanic(author="Ashijin", name="modifyglobalscore", aliases={"mgs"}, description="")
public class ModifyGlobalScoreMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected PlaceholderString objective;
    protected ModifyScoreAction action;
    protected int value;

    public ModifyGlobalScoreMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.objective = PlaceholderString.of(mlc.getString(new String[]{"objective", "obj", "o"}, "", new String[0]));
        this.value = mlc.getInteger(new String[]{"value", "v"});
        String strAction = mlc.getString(new String[]{"action", "a"}, "ADD", new String[0]);
        try {
            this.action = ModifyScoreAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception ex) {
            this.action = ModifyScoreAction.ADD;
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        String fobjective;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = scoreboard.getObjective(fobjective = this.objective.get(data));
        if (objective == null) {
            objective = scoreboard.registerNewObjective(fobjective, "dummy");
        }
        Score score = objective.getScore("__GLOBAL__");
        score.setScore(this.applyModifier(score.getScore()));
        return true;
    }

    protected int applyModifier(int score) {
        if (this.action == ModifyScoreAction.SET) {
            score = this.value;
        } else if (this.action == ModifyScoreAction.ADD) {
            score += this.value;
        } else if (this.action == ModifyScoreAction.SUBTRACT) {
            score -= this.value;
        } else if (this.action == ModifyScoreAction.MULTIPLY) {
            score *= this.value;
        } else if (this.action == ModifyScoreAction.DIVIDE) {
            score /= this.value;
        } else if (this.action == ModifyScoreAction.MOD) {
            score %= this.value;
        }
        return score;
    }

    protected static enum ModifyScoreAction {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD;

    }
}

