/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.util.RandomUtil;
import java.util.Collection;
import java.util.HashSet;

public class ParticleBoxEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float radius;

    public ParticleBoxEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, 5.0f);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        HashSet<AbstractEntity> audience = this.audience.get(data, null);
        this.playParticleBoxEffect(data, target, audience);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        HashSet<AbstractEntity> audience = this.audience.get(data, target);
        this.playParticleBoxEffect(data, target.getLocation(), audience);
        return false;
    }

    protected void playParticleBoxEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        AbstractLocation location = target.clone();
        location.add(0.0, this.yOffset, 0.0);
        int amount = this.amount.get(data);
        for (int i = 0; i < amount; ++i) {
            AbstractVector vector = RandomUtil.getRandomVector().multiply(this.radius);
            location.add(vector);
            this.playParticleEffect(data, location, audience);
            location.subtract(vector);
        }
    }
}

