/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.ParticleMaker;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.Collection;
import java.util.HashSet;

public class ParticleLineEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float distanceBetween;
    protected float startYOffset;
    protected float targetYOffset;
    protected boolean fromOrigin;
    protected boolean zigZag;
    protected int zigZags = 10;
    protected double zigZagOffset;

    public ParticleLineEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo", "ystartoffset", "ys"}, 0.0f);
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "tyo", "ytargetoffset", "yt"}, 0.0f);
        this.distanceBetween = mlc.getFloat(new String[]{"distancebetween", "db"}, 0.25f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.zigZag = mlc.getBoolean(new String[]{"zigzag", "zz"}, false);
        this.zigZags = mlc.getInteger(new String[]{"zigzags", "zzs"}, 10);
        this.zigZagOffset = mlc.getDouble(new String[]{"zigzagoffset", "zzo"}, 0.2);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        HashSet<AbstractEntity> audience = this.audience.get(data, null);
        this.playParticleLineEffect(data, target, audience);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        HashSet<AbstractEntity> audience = this.audience.get(data, target);
        this.playParticleLineEffect(data, target.getLocation(), audience);
        return false;
    }

    protected void playParticleLineEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        int c;
        SkillCaster am = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        AbstractLocation targetLocation = target.clone().add(0.0, this.targetYOffset, 0.0);
        AbstractLocation startLocation = this.fromOrigin ? origin.add(0.0, this.startYOffset, 0.0) : (this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation().add(0.0, this.startYOffset, 0.0));
        if (this.setYaw) {
            startLocation.setYaw(this.yaw);
        }
        if (this.setPitch) {
            startLocation.setPitch(this.pitch);
        }
        if (this.startForwardOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, 0.0, 0.0, this.startSideOffset);
        }
        if ((c = (int)Math.ceil(startLocation.distance(targetLocation) / (double)this.distanceBetween) - 1) <= 0) {
            return;
        }
        AbstractVector v = targetLocation.toVector().subtract(startLocation.toVector()).normalize().multiply(this.distanceBetween);
        AbstractLocation l2 = startLocation.clone().add(0.0, this.yOffset, 0.0);
        boolean zag = false;
        AbstractVector zigZagOffset = null;
        if (this.zigZag) {
            double oX = -(this.zigZagOffset / 2.0) + this.zigZagOffset * Numbers.randomDouble();
            double oY = -(this.zigZagOffset / 2.0) + this.zigZagOffset * Numbers.randomDouble();
            double oZ = -(this.zigZagOffset / 2.0) + this.zigZagOffset * Numbers.randomDouble();
            zigZagOffset = new AbstractVector(oX, oY, oZ);
        }
        int step = 0;
        int amount = c / this.zigZags;
        for (int i = 0; i < c; ++i) {
            if (this.zigZag) {
                if (zag) {
                    l2.add(zigZagOffset);
                } else {
                    l2.subtract(zigZagOffset);
                }
                if (step >= amount) {
                    zag = !zag;
                    step = 0;
                }
                ++step;
            }
            l2.add(v);
            if (this.directional) {
                this.playDirectionalParticleEffect(data, startLocation, targetLocation, l2, audience);
                continue;
            }
            this.playParticleEffect(data, l2, audience);
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, AbstractLocation spawn, Collection<AbstractEntity> audience) {
        AbstractVector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed, this.amount.get(data), this.xSpread, this.vSpread, this.zSpread, direction);
            }
        } else {
            int amount = this.amount.get(data);
            for (int i = 0; i < amount; ++i) {
                AbstractLocation ln = spawn.clone().add((double)(0.0f - this.xSpread) + Numbers.randomDouble() * (double)this.xSpread * 2.0, (double)this.vSpread + Numbers.randomDouble() * (double)this.vSpread * 2.0, (double)(0.0f - this.zSpread) + Numbers.randomDouble() * (double)this.zSpread * 2.0);
                new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed, 1, true).send(ln, this.viewDistance);
            }
        }
    }
}

