/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@MythicMechanic(author="Ashijin", name="potion", description="Applies a potion effect to the target entity")
public class PotionMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString effect;
    protected PlaceholderInt duration;
    protected PlaceholderInt lvl;
    protected boolean overwrite;
    protected boolean ambientParticles;
    protected boolean hasParticles;
    protected boolean hasIcon;

    public PotionMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.effect = mlc.getPlaceholderString(new String[]{"type", "effect", "t"}, "SLOW", new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 100, new String[0]);
        this.lvl = mlc.getPlaceholderInteger(new String[]{"level", "lvl", "l"}, 1, new String[0]);
        this.overwrite = mlc.getBoolean(new String[]{"overwrite", "ow", "override", "or", "force"}, false);
        this.ambientParticles = mlc.getBoolean(new String[]{"ambientparticles", "ambient", "a"}, false);
        this.hasParticles = mlc.getBoolean(new String[]{"hasparticles", "particles", "p"}, true);
        this.hasIcon = mlc.getBoolean(new String[]{"hasicon", "icon", "i"}, true);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        PotionEffect effect;
        String potion = this.effect.get(data, target);
        int duration = this.duration.get(data, target);
        int lvl = this.lvl.get(data, target);
        PotionEffectType type = PotionEffectType.getByName((String)potion);
        try {
            effect = ServerVersion.isAfterOrEq(MinecraftVersions.v1_15) ? new PotionEffect(type, duration, lvl, this.ambientParticles, this.hasParticles, this.hasIcon) : new PotionEffect(type, duration, lvl);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, this.config, "The 'type' attribute must be a valid potion type.");
            return false;
        }
        if (this.overwrite) {
            LivingEntity l = (LivingEntity)target.getBukkitEntity();
            l.removePotionEffect(type);
            l.addPotionEffect(effect);
        } else {
            target.addPotionEffect(effect);
        }
        return true;
    }
}

