/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractGameMode;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="setgamemode", description="Sets the gamemode of the target player")
public class SetGameModeMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected AbstractGameMode mode = AbstractGameMode.SURVIVAL;

    public SetGameModeMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.target_creative = true;
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SURVIVAL", new String[0]);
        try {
            this.mode = AbstractGameMode.valueOf(strMode.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "'" + strMode + "' is not a valid GameMode");
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return false;
        }
        target.asPlayer().setGameMode(this.mode);
        return true;
    }
}

