/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="setlevel", aliases={"modifylevel"}, description="Modifies the castering mob's level")
public class SetLevelMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected SetLevelAction action;
    protected PlaceholderInt level;

    public SetLevelMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        String strAction = mlc.getString(new String[]{"action", "a"}, "SET", new String[0]);
        try {
            this.action = SetLevelAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.level = PlaceholderInt.of(mlc.getString(new String[]{"level", "l"}, "1", new String[0]));
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        int level = this.level.get(data);
        if (this.action == SetLevelAction.SET) {
            am.setLevel(level);
        } else if (this.action == SetLevelAction.ADD) {
            am.setLevel(am.getLevel() + (double)level);
        } else if (this.action == SetLevelAction.SUBTRACT) {
            am.setLevel(am.getLevel() - (double)level);
        } else if (this.action == SetLevelAction.MULTIPLY) {
            am.setLevel(am.getLevel() * (double)level);
        } else if (this.action == SetLevelAction.DIVIDE) {
            am.setLevel(am.getLevel() / (double)level);
        }
        return true;
    }

    protected static enum SetLevelAction {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }
}

