/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;

public class SetOwnerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public SetOwnerMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)data.getCaster();
            am.setOwner(target.getUniqueId());
            if (target.isPlayer()) {
                Entity entity = data.getCaster().getEntity().getBukkitEntity();
                if (entity instanceof Wolf) {
                    ((Wolf)entity).setOwner((AnimalTamer)((Player)target.getBukkitEntity()));
                    ((Wolf)entity).setTamed(true);
                } else if (entity instanceof Parrot) {
                    ((Parrot)entity).setOwner((AnimalTamer)((Player)target.getBukkitEntity()));
                    ((Parrot)entity).setTamed(true);
                } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && entity instanceof Cat) {
                    ((Cat)entity).setOwner((AnimalTamer)((Player)target.getBukkitEntity()));
                    ((Cat)entity).setTamed(true);
                }
            }
            return true;
        }
        return true;
    }
}

