/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="shoot", aliases={"shootprojetile"}, description="Shoots a projectile at the target location")
public class ShootMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected ProjectileType projectileType = ProjectileType.REGULAR;
    protected int damage;
    protected int maxdistance;
    protected float startYOffset;
    protected float startForwardOffset;
    protected float startSideOffset;
    protected PlaceholderDouble projectileVelocity;
    protected float projectileVelocityVertOffset;
    protected float projectileVelocityHorizOffset;
    protected float projectileVelocityAccuracy;
    protected float projectileVelocityVertNoise;
    protected float projectileVelocityHorizNoise;
    protected float projectileVelocityVertNoiseBase;
    protected float projectileVelocityHorizNoiseBase;
    protected boolean powerAffectsVelocity;
    protected Class<? extends Projectile> projectileClass;
    protected ItemStack projectileItem;
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected int tickInterval;
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected Boolean adjustVelocity;
    protected Boolean bounce;
    protected Boolean canPickup;
    protected int pierceLevel;
    protected int knockbackStrength;
    protected boolean gravity;
    protected boolean calculateFiringAngle;
    protected Boolean fromOrigin;
    protected PlaceholderString potionEffectType;
    protected PlaceholderInt potionDuration;
    protected PlaceholderInt potionAmplifier;
    protected boolean overwrite;
    protected boolean ambientParticles;
    protected boolean hasParticles;
    protected boolean hasIcon;
    protected String potionColor;
    protected PlaceholderString tridentItem;
    protected Optional<String> disguise = Optional.empty();

    public ShootMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        String strProjectile = mlc.getString(new String[]{"type", "t"}, "arrow", new String[0]);
        this.damage = mlc.getInteger(new String[]{"damage", "d"}, 5);
        this.maxdistance = mlc.getInteger(new String[]{"maxdistance", "md"}, 64);
        this.projectileVelocity = mlc.getPlaceholderDouble(new String[]{"velocity", "v"}, 1.0, new String[0]);
        this.projectileVelocityVertOffset = mlc.getFloat(new String[]{"verticaloffset", "vo"}, 0.0f);
        this.projectileVelocityHorizOffset = mlc.getFloat(new String[]{"horizontaloffset", "ho"}, 0.0f);
        this.powerAffectsVelocity = mlc.getBoolean(new String[]{"poweraffectsvelocity", "pav"}, true);
        this.bounce = mlc.getBoolean(new String[]{"bounce"}, false);
        this.canPickup = mlc.getBoolean(new String[]{"pickup"}, false);
        this.knockbackStrength = mlc.getInteger(new String[]{"knockback", "kb"}, 0);
        this.pierceLevel = mlc.getInteger(new String[]{"pierceLevel", "pl"}, 0);
        this.gravity = mlc.getBoolean(new String[]{"gravity", "g"}, true);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo"}, 0.0f);
        this.adjustVelocity = mlc.getBoolean(new String[]{"adjustvelocity", "av"}, true);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.calculateFiringAngle = mlc.getBoolean(new String[]{"calculatefiringangle", "cfa"}, false);
        this.disguise = Optional.ofNullable(mlc.getString(new String[]{"disguise", "d"}, null, new String[0]));
        this.projectileVelocityAccuracy = mlc.getFloat(new String[]{"accuracy", "ac", "a"}, 1.0f);
        float defNoise = (1.0f - this.projectileVelocityAccuracy) * 45.0f;
        this.projectileVelocityVertNoise = mlc.getFloat(new String[]{"verticalnoise", "vn"}, defNoise) / 10.0f;
        this.projectileVelocityHorizNoise = mlc.getFloat(new String[]{"horizontalnoise", "hn"}, defNoise);
        this.projectileVelocityVertNoiseBase = 0.0f - this.projectileVelocityVertNoise / 2.0f;
        this.projectileVelocityHorizNoiseBase = 0.0f - this.projectileVelocityHorizNoise / 2.0f;
        switch (strProjectile.toUpperCase()) {
            case "ARROW": {
                this.projectileClass = Arrow.class;
                break;
            }
            case "SNOWBALL": {
                this.projectileClass = Snowball.class;
                break;
            }
            case "EGG": {
                this.projectileClass = Egg.class;
                break;
            }
            case "ENDERPEARL": {
                this.projectileClass = EnderPearl.class;
                break;
            }
            case "POTION": 
            case "SPLASH_POTION": 
            case "LINGERING_POTION": {
                this.projectileType = strProjectile.toUpperCase().equals("LINGERING_POTION") ? ProjectileType.LINGERING_POTION : ProjectileType.POTION;
                this.projectileClass = ThrownPotion.class;
                this.potionEffectType = mlc.getPlaceholderString(new String[]{"potiontype", "ptype", "effect", "pt", "pe"}, "SLOW", new String[0]);
                this.potionDuration = mlc.getPlaceholderInteger(new String[]{"potionduration", "pduration", "pd"}, 100, new String[0]);
                this.potionAmplifier = mlc.getPlaceholderInteger(new String[]{"potionlevel", "plevel", "lvl", "pl"}, 1, new String[0]);
                this.overwrite = mlc.getBoolean(new String[]{"overwrite", "ow", "override", "or", "force"}, false);
                this.potionColor = mlc.getString(new String[]{"potioncolor", "pc"}, "#FFFFFF", new String[0]);
                this.ambientParticles = mlc.getBoolean(new String[]{"ambientparticles", "ambient"}, false);
                this.hasParticles = mlc.getBoolean(new String[]{"hasparticles", "particles"}, true);
                this.hasIcon = mlc.getBoolean(new String[]{"hasicon", "icon"}, true);
                break;
            }
            case "ITEM": {
                this.projectileType = ProjectileType.ITEM;
                break;
            }
            case "BLOCK": 
            case "FALLING_BLOCK": {
                this.projectileType = ProjectileType.BLOCK;
                break;
            }
            case "TRIDENT": {
                this.projectileClass = Trident.class;
                this.tridentItem = mlc.getPlaceholderString(new String[]{"tridentitem", "titem", "ti"}, "", new String[0]);
                this.projectileType = ProjectileType.TRIDENT;
                break;
            }
            default: {
                this.projectileClass = Arrow.class;
            }
        }
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        ShootMechanic.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = ShootMechanic.getPlugin().getSkillManager().getSkill(this.onTickSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Shoot Loaded onTick pointing at " + this.onTickSkillName, new Object[0]);
            if (this.onHitSkillName != null) {
                this.onHitSkill = ShootMechanic.getPlugin().getSkillManager().getSkill(this.onHitSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onHit pointing at " + this.onHitSkillName, new Object[0]);
            if (this.onEndSkillName != null) {
                this.onEndSkill = ShootMechanic.getPlugin().getSkillManager().getSkill(this.onEndSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onEnd pointing at " + this.onEndSkillName, new Object[0]);
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        return this.shoot(data, target);
    }

    public boolean shoot(SkillMetadata data, AbstractLocation target) {
        float noise;
        AbstractVector vector;
        SkillCaster caster = data.getCaster();
        AbstractLocation origin = data.getOrigin().clone();
        float power = data.getPower();
        if (!this.onTickSkill.isPresent() && this.onTickSkillName != null) {
            this.onTickSkill = ShootMechanic.getPlugin().getSkillManager().getSkill(this.onTickSkillName);
        }
        if (!this.onHitSkill.isPresent() && this.onHitSkillName != null) {
            this.onHitSkill = ShootMechanic.getPlugin().getSkillManager().getSkill(this.onHitSkillName);
        }
        if (!this.onEndSkill.isPresent() && this.onEndSkillName != null) {
            this.onEndSkill = ShootMechanic.getPlugin().getSkillManager().getSkill(this.onEndSkillName);
        }
        float v = (float)this.projectileVelocity.get(data) * 3.0f;
        if (this.powerAffectsVelocity) {
            v *= power;
        }
        if (this.startYOffset > 0.0f) {
            origin = origin.add(0.0, this.startYOffset, 0.0);
        }
        if (this.startForwardOffset != 0.0f) {
            origin = MythicUtil.move(origin, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            origin = MythicUtil.move(origin, 0.0, 0.0, this.startSideOffset);
        }
        if (this.fromOrigin.booleanValue()) {
            vector = target.toVector().subtract(origin.toVector()).normalize();
        } else if (caster.getEntity().isPlayer() && this.adjustVelocity.booleanValue()) {
            float yaw = caster.getEntity().getEyeLocation().getYaw();
            float pitch = caster.getEntity().getEyeLocation().getPitch();
            double xVel = -Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
            double yVel = -Math.sin(Math.toRadians(pitch));
            double zVel = Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
            vector = new AbstractVector(xVel, yVel, zVel).normalize();
        } else {
            vector = target.toVector().subtract(caster.getEntity().getLocation().toVector()).normalize();
        }
        if (this.projectileVelocityHorizOffset != 0.0f || this.projectileVelocityHorizNoise > 0.0f) {
            noise = 0.0f;
            if (this.projectileVelocityHorizNoise > 0.0f) {
                noise = (float)((double)this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityHorizNoise);
            }
            vector.rotate(this.projectileVelocityHorizOffset + noise);
        }
        if (this.projectileVelocityVertOffset != 0.0f || this.projectileVelocityVertNoise > 0.0f) {
            noise = 0.0f;
            if (this.projectileVelocityVertNoise > 0.0f) {
                noise = (float)((double)this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityVertNoise);
            }
            vector.add(new AbstractVector(0.0f, this.projectileVelocityVertOffset + noise, 0.0f)).normalize();
        }
        vector = vector.multiply(v);
        AbstractEntity projectile = this.projectileType == ProjectileType.ITEM || this.projectileType == ProjectileType.BLOCK || this.projectileType == ProjectileType.POTION || this.projectileType == ProjectileType.LINGERING_POTION || this.projectileType == ProjectileType.TRIDENT ? SkillAdapter.get().shootProjectile(caster, target, origin, this.projectileClass, vector, this) : (this.calculateFiringAngle && this.gravity ? SkillAdapter.get().shootArcProjectile(caster, target, origin, this.projectileClass, v, this.fromOrigin) : SkillAdapter.get().shootProjectile(caster, target, origin, this.projectileClass, vector, this));
        if (!this.gravity) {
            projectile.setGravity(false);
        }
        if (this.disguise.isPresent()) {
            MythicMobs.inst().getCompatibility();
            if (CompatibilityManager.LibsDisguises.enabled) {
                // empty if block
            }
        }
        new ProjectileTracker(data, projectile, power);
        return true;
    }

    public ProjectileType getProjectileType() {
        return this.projectileType;
    }

    public Boolean getAdjustVelocity() {
        return this.adjustVelocity;
    }

    public Boolean getBounce() {
        return this.bounce;
    }

    public Boolean getCanPickup() {
        return this.canPickup;
    }

    public int getPierceLevel() {
        return this.pierceLevel;
    }

    public int getKnockbackStrength() {
        return this.knockbackStrength;
    }

    public Boolean getFromOrigin() {
        return this.fromOrigin;
    }

    public PlaceholderString getPotionEffectType() {
        return this.potionEffectType;
    }

    public PlaceholderInt getPotionDuration() {
        return this.potionDuration;
    }

    public PlaceholderInt getPotionAmplifier() {
        return this.potionAmplifier;
    }

    public String getPotionColor() {
        return this.potionColor;
    }

    public PlaceholderString getTridentItem() {
        return this.tridentItem;
    }

    protected class ProjectileTracker
    implements Runnable,
    Terminable {
        private final TerminableRegistry registry = TerminableRegistry.create();
        private SkillMetadata data;
        private SkillCaster caster;
        private AbstractEntity projectile;
        private boolean hasEnded = false;
        private float power;

        public ProjectileTracker(SkillMetadata caster, AbstractEntity projectile, float power) {
            this.caster = caster.getCaster();
            this.data = caster.deepClone();
            this.data.setIsAsync(true);
            this.projectile = projectile;
            this.power = power;
            this.registry.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getDamager() instanceof Projectile).filter(event -> event.getEntity() instanceof LivingEntity).filter(event -> event.getDamager().getUniqueId().equals(projectile.getUniqueId())).handler(this::doHitSkill));
            this.registry.accept(Schedulers.async().runRepeating(this, 0L, (long)ShootMechanic.this.tickInterval));
        }

        @Override
        public void run() {
            if (!this.projectile.isValid() || this.projectile.getBukkitEntity() instanceof Projectile && ((Projectile)this.projectile.getBukkitEntity()).isOnGround()) {
                this.doEndSkill();
                this.close();
            }
            if (ShootMechanic.this.onTickSkill.isPresent() && ShootMechanic.this.onTickSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(this.projectile.getLocation().clone());
                sData.setLocationTargets(targets);
                sData.setOrigin(this.projectile.getLocation().clone());
                sData.setPower(this.power);
                ShootMechanic.this.onTickSkill.get().execute(sData);
            }
        }

        public void doHitSkill(EntityDamageByEntityEvent event) {
            this.close();
            Projectile projectile = (Projectile)event.getDamager();
            AbstractEntity proj = BukkitAdapter.adapt((Entity)projectile);
            AbstractEntity target = BukkitAdapter.adapt(event.getEntity());
            HashSet<AbstractEntity> t = Sets.newHashSet();
            t.add(target);
            SkillMetadata meta = new SkillMetadata(SkillTrigger.ATTACK, this.caster, target, proj.getLocation(), t, null, this.power);
            if (ShootMechanic.this.damage == 0) {
                event.setCancelled(true);
            } else {
                event.setDamage((double)ShootMechanic.this.damage);
            }
            if (ShootMechanic.this.onHitSkill.isPresent() && ShootMechanic.this.onHitSkill.get().usable(meta, null)) {
                ShootMechanic.this.onHitSkill.get().execute(meta);
            }
        }

        private void doEndSkill() {
            if (!this.hasEnded && ShootMechanic.this.onEndSkill.isPresent()) {
                if (ShootMechanic.this.onEndSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                    targets.add(this.projectile.getLocation().clone());
                    sData.setLocationTargets(targets);
                    sData.setOrigin(this.projectile.getLocation().clone());
                    sData.setPower(this.power);
                    ShootMechanic.this.onEndSkill.get().execute(sData);
                }
                this.hasEnded = true;
            }
        }

        @Override
        public void close() {
            this.registry.terminate();
            if (!ShootMechanic.this.canPickup.booleanValue()) {
                Schedulers.sync().runLater(() -> this.projectile.remove(), 100L);
            }
        }
    }

    public static enum ProjectileType {
        REGULAR,
        ITEM,
        BLOCK,
        POTION,
        LINGERING_POTION,
        TRIDENT;

    }
}

