/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class SmokeSwirlEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int duration;
    protected int interval;

    public SmokeSwirlEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 5);
        this.interval = mlc.getInteger(new String[]{"interval", "i"}, 1);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(BukkitAdapter.adapt(target), this.interval, this.duration);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(BukkitAdapter.adapt(target), this.interval, this.duration);
        return false;
    }

    private class Animator
    implements Runnable {
        private Entity entity;
        private Location location;
        private int interval;
        private int duration;
        private int iteration;
        private int taskId;
        private int[] x = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        private int[] z = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        private int[] v = new int[]{7, 6, 3, 0, 1, 2, 5, 8};

        public Animator(Location location, int interval, int duration) {
            this(interval, duration);
            this.location = location;
        }

        public Animator(Entity entity, int interval, int duration) {
            this(interval, duration);
            this.entity = entity;
        }

        protected Animator(int interval, int duration) {
            this.interval = interval;
            this.duration = duration;
            this.iteration = 0;
            this.taskId = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MythicMobs.inst(), (Runnable)this, 0L, (long)interval);
        }

        @Override
        public void run() {
            if (this.iteration * this.interval > this.duration) {
                Bukkit.getScheduler().cancelTask(this.taskId);
            } else {
                int i = this.iteration % 8;
                Location loc = this.location != null ? this.location : this.entity.getLocation();
                loc.getWorld().playEffect(loc.clone().add((double)this.x[i], 0.0, (double)this.z[i]), Effect.SMOKE, this.v[i]);
                ++this.iteration;
            }
        }
    }
}

