/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin/jaylawl", name="threat", aliases={"threatchange", "threatmod"}, description="Modifies the target entities' threat level")
public class ThreatMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString mode;
    protected PlaceholderDouble amount;

    public ThreatMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = false;
        this.mode = mlc.getPlaceholderString(new String[]{"mode", "m"}, "add", new String[0]);
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "a"}, 1.0, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return false;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        if (am.getThreatTable() == null) {
            return false;
        }
        if (MythicMobs.inst().getMobManager().isActiveMob(target)) {
            ActiveMob amt = MythicMobs.inst().getMobManager().getMythicMobInstance(target);
            if (am.hasFaction() && am.getFaction().equals(amt.getFaction())) {
                return false;
            }
        }
        String mode = this.mode.get(data, target);
        double amount = this.amount.get(data, target);
        switch (mode) {
            case "add": {
                if (amount > 0.0) {
                    am.getThreatTable().threatGain(target, amount);
                    break;
                }
                am.getThreatTable().threatLoss(target, amount * -1.0);
                break;
            }
            case "remove": {
                if (amount > 0.0) {
                    am.getThreatTable().threatLoss(target, amount);
                    break;
                }
                am.getThreatTable().threatGain(target, amount * -1.0);
                break;
            }
            case "multiply": {
                am.getThreatTable().threatSet(target, am.getThreatTable().getThreat(target) * amount);
                break;
            }
            case "divide": {
                if (amount == 0.0) {
                    return false;
                }
                am.getThreatTable().threatSet(target, am.getThreatTable().getThreat(target) / amount);
                break;
            }
            case "set": {
                am.getThreatTable().threatSet(target, amount);
                break;
            }
            case "reset": 
            case "delete": {
                am.getThreatTable().threatLoss(target, am.getThreatTable().getThreat(target));
                break;
            }
            case "forcetop": 
            case "force": 
            case "topthreat": 
            case "top": {
                am.getThreatTable().threatSet(target, am.getThreatTable().getTopTargetThreat() + 1.0);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + mode);
            }
        }
        return true;
    }
}

