/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootMechanic;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;

@MythicMechanic(author="Ashijin", name="volley", aliases={"shootvolley"}, description="Fires a volley of projectiles")
public class VolleyMechanic
extends ShootMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected VolleyType type;
    protected PlaceholderInt amount;
    protected double radius;
    protected double yOffset;

    public VolleyMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        String strType = mlc.getString(new String[]{"source", "s"}, "REGULAR", new String[0]).toUpperCase();
        this.type = strType.equals("RAIN") ? VolleyType.RAIN : VolleyType.REGULAR;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 10, new String[0]);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 0.0);
        this.yOffset = mlc.getDouble("yoffset", 1.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target.getLocation());
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        return this.shoot(data, target);
    }

    @Override
    public boolean shoot(SkillMetadata data, AbstractLocation target) {
        SkillCaster caster = data.getCaster();
        AbstractLocation origin = data.getOrigin().clone();
        AbstractLocation primeSource = null;
        if (this.type.equals((Object)VolleyType.RAIN)) {
            primeSource = target.clone().add(0.0, this.yOffset, 0.0);
        }
        if (this.startYOffset > 0.0f) {
            origin = origin.add(0.0, this.startYOffset, 0.0);
        }
        if (this.startForwardOffset != 0.0f) {
            origin = MythicUtil.move(origin, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            origin = MythicUtil.move(origin, 0.0, 0.0, this.startSideOffset);
        }
        float velocity = (float)this.projectileVelocity.get(data);
        if (this.powerAffectsVelocity) {
            velocity *= this.power;
        }
        AbstractVector vector = this.fromOrigin == true ? target.toVector().subtract(origin.toVector()).normalize().multiply(velocity) : target.toVector().subtract(caster.getEntity().getLocation().toVector()).normalize().multiply(velocity);
        int amount = this.amount.get(data);
        for (int i = 0; i < amount; ++i) {
            AbstractEntity projectile;
            if (this.type.equals((Object)VolleyType.RAIN)) {
                AbstractLocation source = primeSource.clone();
                source.setX(source.getX() - this.radius + Numbers.randomDouble() * (this.radius * 2.0));
                source.setZ(source.getZ() - this.radius + Numbers.randomDouble() * (this.radius * 2.0));
                projectile = this.projectileType.equals((Object)ShootMechanic.ProjectileType.ITEM) ? SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity) : (this.projectileType.equals((Object)ShootMechanic.ProjectileType.BLOCK) ? SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity) : SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity));
            } else {
                projectile = this.projectileType.equals((Object)ShootMechanic.ProjectileType.ITEM) ? SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, vector, this) : (this.projectileType.equals((Object)ShootMechanic.ProjectileType.BLOCK) ? SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, vector, this) : SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, vector, this));
            }
            new ShootMechanic.ProjectileTracker(this, data, projectile, this.power);
        }
        return true;
    }

    protected static enum VolleyType {
        REGULAR,
        RAIN;

    }
}

