/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.placeholders.parsers;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderParser;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.RandomFloat;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.StaticFloat;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderFloat
extends PlaceholderParser {
    public PlaceholderFloat(String string) {
        super(string);
        if (string != null && string.startsWith("=")) {
            this.doMath = true;
        }
    }

    public float get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return (float)new ExpressionBuilder(string).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderString: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return Float.valueOf(string).floatValue();
    }

    public float get(PlaceholderMeta meta) {
        return this.get(meta, meta == null ? null : meta.getTrigger());
    }

    public float get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    public float get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicMobs.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return (float)new ExpressionBuilder(string).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderString: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return Float.valueOf(string).floatValue();
    }

    public float get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderFloat of(String string) {
        try {
            if (io.lumine.xikage.mythicmobs.utils.numbers.RandomFloat.matches(string)) {
                return new RandomFloat(string);
            }
            if (string.matches("-?\\d+\\.?\\d*")) {
                return new StaticFloat(string);
            }
            if (!MythicMobs.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythicmobs.net.");
                return new StaticFloat("1");
            }
            return new PlaceholderFloat(string);
        }
        catch (Exception exception) {
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticFloat("1");
        }
    }
}

