/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicTargeterLoadEvent;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.TriggerTargeter;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CustomTargeter
extends SkillTargeter {
    protected final String targeterName;
    protected final MythicLineConfig config;
    protected SkillTargeter targeter = null;
    protected boolean loaded = false;

    public CustomTargeter(String targeter, MythicLineConfig mlc) {
        super(mlc);
        this.targeterName = targeter;
        this.config = mlc;
        this.targeter = new TriggerTargeter(mlc);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Loading CustomTargeter with name " + targeter, new Object[0]);
        Schedulers.sync().runLater(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Attempting to Register CustomTargeter: " + targeter, new Object[0]);
            MythicTargeterLoadEvent event = new MythicTargeterLoadEvent(this, targeter, this.config);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.getTargeter().isPresent()) {
                this.targeter = event.getTargeter().get();
                this.loaded = true;
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loaded Custom Targeter {0}", this.targeterName);
            } else {
                MythicLogger.errorTargeterConfig(this, mlc, "Failed to load custom targeter " + this.targeterName);
            }
        }, 1L);
    }

    public Optional<SkillTargeter> getTargeter() {
        return Optional.ofNullable(this.targeter);
    }
}

