/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.util.jnbt;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderDouble;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderFloat;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.jnbt.ByteArrayTag;
import io.lumine.xikage.mythicmobs.util.jnbt.ByteTag;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.util.jnbt.DoubleTag;
import io.lumine.xikage.mythicmobs.util.jnbt.FloatTag;
import io.lumine.xikage.mythicmobs.util.jnbt.IntArrayTag;
import io.lumine.xikage.mythicmobs.util.jnbt.IntTag;
import io.lumine.xikage.mythicmobs.util.jnbt.LongTag;
import io.lumine.xikage.mythicmobs.util.jnbt.PlaceholderDoubleTag;
import io.lumine.xikage.mythicmobs.util.jnbt.PlaceholderFloatTag;
import io.lumine.xikage.mythicmobs.util.jnbt.PlaceholderIntTag;
import io.lumine.xikage.mythicmobs.util.jnbt.PlaceholderStringTag;
import io.lumine.xikage.mythicmobs.util.jnbt.ShortTag;
import io.lumine.xikage.mythicmobs.util.jnbt.StringTag;
import io.lumine.xikage.mythicmobs.util.jnbt.Tag;
import java.util.HashMap;
import java.util.Map;

public class CompoundTagBuilder {
    private final Map<String, Tag> entries;

    CompoundTagBuilder() {
        this.entries = new HashMap<String, Tag>();
    }

    CompoundTagBuilder(Map<String, Tag> value) {
        CompoundTagBuilder.checkNotNull(value);
        this.entries = value;
    }

    public CompoundTagBuilder put(String key, Tag value) {
        CompoundTagBuilder.checkNotNull(key);
        CompoundTagBuilder.checkNotNull(value);
        this.entries.put(key, value);
        return this;
    }

    public CompoundTagBuilder putByteArray(String key, byte[] value) {
        return this.put(key, new ByteArrayTag(value));
    }

    public CompoundTagBuilder putByte(String key, byte value) {
        return this.put(key, new ByteTag(value));
    }

    public CompoundTagBuilder putBoolean(String key, boolean value) {
        return this.putByte(key, (byte)(value ? 1 : 0));
    }

    public CompoundTagBuilder putDouble(String key, double value) {
        return this.put(key, new DoubleTag(value));
    }

    public CompoundTagBuilder putPlaceholderDouble(String key, PlaceholderDouble value) {
        return this.put(key, new PlaceholderDoubleTag(value));
    }

    public CompoundTagBuilder putPlaceholderFloat(String key, PlaceholderFloat value) {
        return this.put(key, new PlaceholderFloatTag(value));
    }

    public CompoundTagBuilder putFloat(String key, float value) {
        return this.put(key, new FloatTag(value));
    }

    public CompoundTagBuilder putIntArray(String key, int[] value) {
        return this.put(key, new IntArrayTag(value));
    }

    public CompoundTagBuilder putInt(String key, int value) {
        return this.put(key, new IntTag(value));
    }

    public CompoundTagBuilder putPlaceholderInt(String key, PlaceholderInt value) {
        return this.put(key, new PlaceholderIntTag(value));
    }

    public CompoundTagBuilder putLong(String key, long value) {
        return this.put(key, new LongTag(value));
    }

    public CompoundTagBuilder putShort(String key, short value) {
        return this.put(key, new ShortTag(value));
    }

    public CompoundTagBuilder putString(String key, String value) {
        return this.put(key, new StringTag(value));
    }

    public CompoundTagBuilder putPlaceholderString(String key, PlaceholderString value) {
        return this.put(key, new PlaceholderStringTag(value));
    }

    public CompoundTagBuilder putAll(Map<String, ? extends Tag> value) {
        CompoundTagBuilder.checkNotNull(value);
        for (Map.Entry<String, ? extends Tag> entry : value.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public CompoundTagBuilder remove(String key) {
        this.entries.remove(key);
        return this;
    }

    public CompoundTag build() {
        try {
            return MythicMobs.inst().getVolatileCodeHandler().createCompoundTag(new HashMap<String, Tag>(this.entries));
        }
        catch (Exception ex) {
            MythicLogger.error("This version of Minecraft is not supported for NBT/Data");
            return null;
        }
        catch (Error ex) {
            MythicLogger.error("This version of Minecraft is not supported for NBT/Data");
            return null;
        }
    }

    public static CompoundTagBuilder create() {
        return new CompoundTagBuilder();
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }
}

