/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.nbt;

import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagType;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagTypes;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ByteArrayBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.CompoundBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.IntArrayBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ListBinaryTagImpl;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ListTagBuilder;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ListTagSetter;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.LongArrayBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.NumberBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.StringBinaryTag;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ListBinaryTag
extends ListTagSetter<ListBinaryTag, BinaryTag>,
BinaryTag,
Iterable<BinaryTag> {
    public static @NonNull ListBinaryTag empty() {
        return ListBinaryTagImpl.EMPTY;
    }

    public static @NonNull ListBinaryTag from(@NonNull Iterable<? extends BinaryTag> tags) {
        return ((Builder)ListBinaryTag.builder().add(tags)).build();
    }

    public static @NonNull Builder<BinaryTag> builder() {
        return new ListTagBuilder<BinaryTag>();
    }

    public static <T extends BinaryTag> @NonNull Builder<T> builder(@NonNull BinaryTagType<T> type) {
        if (type == BinaryTagTypes.END) {
            throw new IllegalArgumentException("Cannot create a list of " + BinaryTagTypes.END);
        }
        return new ListTagBuilder(type);
    }

    public static @NonNull ListBinaryTag of(@NonNull BinaryTagType<? extends BinaryTag> type, @NonNull List<BinaryTag> tags) {
        if (tags.isEmpty()) {
            return ListBinaryTag.empty();
        }
        if (type == BinaryTagTypes.END) {
            throw new IllegalArgumentException("Cannot create a list of " + BinaryTagTypes.END);
        }
        return new ListBinaryTagImpl(type, tags);
    }

    default public @NonNull BinaryTagType<ListBinaryTag> type() {
        return BinaryTagTypes.LIST;
    }

    @Deprecated
    default public @NonNull BinaryTagType<? extends BinaryTag> listType() {
        return this.elementType();
    }

    public @NonNull BinaryTagType<? extends BinaryTag> elementType();

    public int size();

    public @NonNull BinaryTag get(@NonNegative int var1);

    public @NonNull ListBinaryTag set(int var1, @NonNull BinaryTag var2, @Nullable Consumer<? super BinaryTag> var3);

    public @NonNull ListBinaryTag remove(int var1, @Nullable Consumer<? super BinaryTag> var2);

    default public byte getByte(@NonNegative int index) {
        return this.getByte(index, (byte)0);
    }

    default public byte getByte(@NonNegative int index, byte defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type().numeric()) {
            return ((NumberBinaryTag)tag).byteValue();
        }
        return defaultValue;
    }

    default public short getShort(@NonNegative int index) {
        return this.getShort(index, (short)0);
    }

    default public short getShort(@NonNegative int index, short defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type().numeric()) {
            return ((NumberBinaryTag)tag).shortValue();
        }
        return defaultValue;
    }

    default public int getInt(@NonNegative int index) {
        return this.getInt(index, 0);
    }

    default public int getInt(@NonNegative int index, int defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type().numeric()) {
            return ((NumberBinaryTag)tag).intValue();
        }
        return defaultValue;
    }

    default public long getLong(@NonNegative int index) {
        return this.getLong(index, 0L);
    }

    default public long getLong(@NonNegative int index, long defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type().numeric()) {
            return ((NumberBinaryTag)tag).longValue();
        }
        return defaultValue;
    }

    default public float getFloat(@NonNegative int index) {
        return this.getFloat(index, 0.0f);
    }

    default public float getFloat(@NonNegative int index, float defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type().numeric()) {
            return ((NumberBinaryTag)tag).floatValue();
        }
        return defaultValue;
    }

    default public double getDouble(@NonNegative int index) {
        return this.getDouble(index, 0.0);
    }

    default public double getDouble(@NonNegative int index, double defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type().numeric()) {
            return ((NumberBinaryTag)tag).doubleValue();
        }
        return defaultValue;
    }

    default public byte @NonNull [] getByteArray(@NonNegative int index) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.BYTE_ARRAY) {
            return ((ByteArrayBinaryTag)tag).value();
        }
        return new byte[0];
    }

    default public byte @NonNull [] getByteArray(@NonNegative int index, byte @NonNull [] defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.BYTE_ARRAY) {
            return ((ByteArrayBinaryTag)tag).value();
        }
        return defaultValue;
    }

    default public @NonNull String getString(@NonNegative int index) {
        return this.getString(index, "");
    }

    default public @NonNull String getString(@NonNegative int index, @NonNull String defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.STRING) {
            return ((StringBinaryTag)tag).value();
        }
        return defaultValue;
    }

    default public @NonNull ListBinaryTag getList(@NonNegative int index) {
        return this.getList(index, null, ListBinaryTag.empty());
    }

    default public @NonNull ListBinaryTag getList(@NonNegative int index, @Nullable BinaryTagType<?> elementType) {
        return this.getList(index, elementType, ListBinaryTag.empty());
    }

    default public @NonNull ListBinaryTag getList(@NonNegative int index, @NonNull ListBinaryTag defaultValue) {
        return this.getList(index, null, defaultValue);
    }

    default public @NonNull ListBinaryTag getList(@NonNegative int index, @Nullable BinaryTagType<?> elementType, @NonNull ListBinaryTag defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.LIST) {
            ListBinaryTag list = (ListBinaryTag)tag;
            if (elementType == null || list.elementType() == elementType) {
                return list;
            }
        }
        return defaultValue;
    }

    default public @NonNull CompoundBinaryTag getCompound(@NonNegative int index) {
        return this.getCompound(index, CompoundBinaryTag.empty());
    }

    default public @NonNull CompoundBinaryTag getCompound(@NonNegative int index, @NonNull CompoundBinaryTag defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.COMPOUND) {
            return (CompoundBinaryTag)tag;
        }
        return defaultValue;
    }

    default public int @NonNull [] getIntArray(@NonNegative int index) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.INT_ARRAY) {
            return ((IntArrayBinaryTag)tag).value();
        }
        return new int[0];
    }

    default public int @NonNull [] getIntArray(@NonNegative int index, int @NonNull [] defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.INT_ARRAY) {
            return ((IntArrayBinaryTag)tag).value();
        }
        return defaultValue;
    }

    default public long @NonNull [] getLongArray(@NonNegative int index) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.LONG_ARRAY) {
            return ((LongArrayBinaryTag)tag).value();
        }
        return new long[0];
    }

    default public long @NonNull [] getLongArray(@NonNegative int index, long @NonNull [] defaultValue) {
        BinaryTag tag = this.get(index);
        if (tag.type() == BinaryTagTypes.LONG_ARRAY) {
            return ((LongArrayBinaryTag)tag).value();
        }
        return defaultValue;
    }

    public @NonNull Stream<BinaryTag> stream();

    public static interface Builder<T extends BinaryTag>
    extends ListTagSetter<Builder<T>, T> {
        public @NonNull ListBinaryTag build();
    }
}

