/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.inbuild;

import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.TextComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.event.ClickEvent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.ParsingException;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.Token;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.TokenType;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.Transformation;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.TransformationParser;
import io.lumine.xikage.mythicmobs.utils.text.examination.ExaminableProperty;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ClickTransformation
extends Transformation {
    private ClickEvent.Action action;
    private String value;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("click");
    }

    private ClickTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (args.size() >= 3 && args.get(0).type() == TokenType.STRING && args.get(2).type() == TokenType.STRING) {
            this.action = ClickEvent.Action.NAMES.value(args.get(0).value().toLowerCase(Locale.ROOT));
            this.value = Token.asValueString(args.subList(2, args.size()));
        } else if (args.size() >= 5 && args.get(0).type() == TokenType.STRING && args.get(2).type() == TokenType.QUOTE_START && args.get(args.size() - 1).type() == TokenType.QUOTE_END) {
            this.action = ClickEvent.Action.NAMES.value(args.get(0).value().toLowerCase(Locale.ROOT));
            this.value = Token.asValueString(args.subList(3, args.size() - 1));
        } else {
            throw new ParsingException("Doesn't know how to turn " + args + " into a click event", -1);
        }
    }

    @Override
    public Component apply(Component component, TextComponent.Builder parent) {
        return component.clickEvent(ClickEvent.clickEvent(this.action, this.value));
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", (Object)this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClickTransformation that = (ClickTransformation)other;
        return this.action == that.action && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.value});
    }

    public static class Parser
    implements TransformationParser<ClickTransformation> {
        @Override
        public ClickTransformation parse() {
            return new ClickTransformation();
        }
    }
}

