/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.collections.expiringmap;

import io.lumine.xikage.mythicmobs.utils.collections.expiringmap.EntryLoader;
import io.lumine.xikage.mythicmobs.utils.collections.expiringmap.ExpirationListener;
import io.lumine.xikage.mythicmobs.utils.collections.expiringmap.ExpirationPolicy;
import io.lumine.xikage.mythicmobs.utils.collections.expiringmap.ExpiringEntryLoader;
import io.lumine.xikage.mythicmobs.utils.collections.expiringmap.ExpiringValue;
import io.lumine.xikage.mythicmobs.utils.collections.expiringmap.internal.Assert;
import io.lumine.xikage.mythicmobs.utils.collections.expiringmap.internal.NamedThreadFactory;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ExpiringMap<K, V>
implements ConcurrentMap<K, V> {
    static volatile ScheduledExecutorService EXPIRER;
    static volatile ThreadPoolExecutor LISTENER_SERVICE;
    static ThreadFactory THREAD_FACTORY;
    List<ExpirationListener<K, V>> expirationListeners;
    List<ExpirationListener<K, V>> asyncExpirationListeners;
    private AtomicLong expirationNanos;
    private int maxSize;
    private final AtomicReference<ExpirationPolicy> expirationPolicy;
    private final EntryLoader<? super K, ? extends V> entryLoader;
    private final ExpiringEntryLoader<? super K, ? extends V> expiringEntryLoader;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final EntryMap<K, V> entries;
    private final boolean variableExpiration;

    public static void setThreadFactory(ThreadFactory threadFactory) {
        THREAD_FACTORY = Assert.notNull(threadFactory, "threadFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ExpiringMap(Builder<K, V> builder) {
        Class<ExpiringMap> clazz;
        if (EXPIRER == null) {
            clazz = ExpiringMap.class;
            // MONITORENTER : io.lumine.xikage.mythicmobs.utils.collections.expiringmap.ExpiringMap.class
            if (EXPIRER == null) {
                EXPIRER = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY == null ? new NamedThreadFactory("ExpiringMap-Expirer") : THREAD_FACTORY);
            }
            // MONITOREXIT : clazz
        }
        if (LISTENER_SERVICE == null && ((Builder)builder).asyncExpirationListeners != null) {
            clazz = ExpiringMap.class;
            // MONITORENTER : io.lumine.xikage.mythicmobs.utils.collections.expiringmap.ExpiringMap.class
            if (LISTENER_SERVICE == null) {
                LISTENER_SERVICE = (ThreadPoolExecutor)Executors.newCachedThreadPool(THREAD_FACTORY == null ? new NamedThreadFactory("ExpiringMap-Listener-%s") : THREAD_FACTORY);
            }
            // MONITOREXIT : clazz
        }
        this.variableExpiration = ((Builder)builder).variableExpiration;
        this.entries = (EntryMap)((Object)(this.variableExpiration ? new EntryTreeHashMap() : new EntryLinkedHashMap()));
        if (((Builder)builder).expirationListeners != null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>(((Builder)builder).expirationListeners);
        }
        if (((Builder)builder).asyncExpirationListeners != null) {
            this.asyncExpirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>(((Builder)builder).asyncExpirationListeners);
        }
        this.expirationPolicy = new AtomicReference<ExpirationPolicy>(((Builder)builder).expirationPolicy);
        this.expirationNanos = new AtomicLong(TimeUnit.NANOSECONDS.convert(((Builder)builder).duration, ((Builder)builder).timeUnit));
        this.maxSize = ((Builder)builder).maxSize;
        this.entryLoader = ((Builder)builder).entryLoader;
        this.expiringEntryLoader = ((Builder)builder).expiringEntryLoader;
    }

    public static Builder<Object, Object> builder() {
        return new Builder<Object, Object>();
    }

    public static <K, V> ExpiringMap<K, V> create() {
        return new ExpiringMap<Object, Object>(ExpiringMap.builder());
    }

    public synchronized void addExpirationListener(ExpirationListener<K, V> listener) {
        Assert.notNull(listener, "listener");
        if (this.expirationListeners == null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>();
        }
        this.expirationListeners.add(listener);
    }

    public synchronized void addAsyncExpirationListener(ExpirationListener<K, V> listener) {
        Assert.notNull(listener, "listener");
        if (this.asyncExpirationListeners == null) {
            this.asyncExpirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>();
        }
        this.asyncExpirationListeners.add(listener);
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            for (ExpiringEntry entry : this.entries.values()) {
                entry.cancel();
            }
            this.entries.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object entry) {
                if (!(entry instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)entry;
                return ExpiringMap.this.containsKey(e.getKey());
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return ExpiringMap.this.entries instanceof EntryLinkedHashMap ? (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.EntryIterator() : (EntryTreeHashMap)ExpiringMap.this.entries.new EntryTreeHashMap.EntryIterator();
            }

            @Override
            public boolean remove(Object entry) {
                if (entry instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)entry;
                    return ExpiringMap.this.remove(e.getKey()) != null;
                }
                return false;
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.equals(obj);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        ExpiringEntry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return this.load(key);
        }
        if (ExpirationPolicy.ACCESSED.equals((Object)entry.expirationPolicy.get())) {
            this.resetEntry(entry, false);
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V load(K key) {
        if (this.entryLoader == null && this.expiringEntryLoader == null) {
            return null;
        }
        this.writeLock.lock();
        try {
            ExpiringEntry<K, V> entry = this.getEntry(key);
            if (entry != null) {
                V v = entry.getValue();
                return v;
            }
            if (this.entryLoader != null) {
                V value = this.entryLoader.load(key);
                this.put(key, value);
                V v = value;
                return v;
            }
            ExpiringValue<V> expiringValue = this.expiringEntryLoader.load(key);
            if (expiringValue == null) {
                this.put(key, null);
                V v = null;
                return v;
            }
            long duration = expiringValue.getTimeUnit() == null ? this.expirationNanos.get() : expiringValue.getDuration();
            TimeUnit timeUnit = expiringValue.getTimeUnit() == null ? TimeUnit.NANOSECONDS : expiringValue.getTimeUnit();
            this.put(key, expiringValue.getValue(), expiringValue.getExpirationPolicy() == null ? this.expirationPolicy.get() : expiringValue.getExpirationPolicy(), duration, timeUnit);
            V v = expiringValue.getValue();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getExpiration() {
        return TimeUnit.NANOSECONDS.toMillis(this.expirationNanos.get());
    }

    public long getExpiration(K key) {
        Assert.notNull(key, "key");
        ExpiringEntry<K, V> entry = this.getEntry(key);
        Assert.element(entry, key);
        return TimeUnit.NANOSECONDS.toMillis(entry.expirationNanos.get());
    }

    public ExpirationPolicy getExpirationPolicy(K key) {
        Assert.notNull(key, "key");
        ExpiringEntry<K, V> entry = this.getEntry(key);
        Assert.element(entry, key);
        return entry.expirationPolicy.get();
    }

    public long getExpectedExpiration(K key) {
        Assert.notNull(key, "key");
        ExpiringEntry<K, V> entry = this.getEntry(key);
        Assert.element(entry, key);
        return TimeUnit.NANOSECONDS.toMillis(entry.expectedExpiration.get() - System.nanoTime());
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.entries.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.entries.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object key) {
                return ExpiringMap.this.containsKey(key);
            }

            @Override
            public Iterator<K> iterator() {
                return ExpiringMap.this.entries instanceof EntryLinkedHashMap ? (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.KeyIterator() : (EntryTreeHashMap)ExpiringMap.this.entries.new EntryTreeHashMap.KeyIterator();
            }

            @Override
            public boolean remove(Object value) {
                return ExpiringMap.this.remove(value) != null;
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        Assert.notNull(key, "key");
        return this.putInternal(key, value, this.expirationPolicy.get(), this.expirationNanos.get());
    }

    public V put(K key, V value, ExpirationPolicy expirationPolicy) {
        return this.put(key, value, expirationPolicy, this.expirationNanos.get(), TimeUnit.NANOSECONDS);
    }

    public V put(K key, V value, long duration, TimeUnit timeUnit) {
        return this.put(key, value, this.expirationPolicy.get(), duration, timeUnit);
    }

    public V put(K key, V value, ExpirationPolicy expirationPolicy, long duration, TimeUnit timeUnit) {
        Assert.notNull(key, "key");
        Assert.notNull(expirationPolicy, "expirationPolicy");
        Assert.notNull(timeUnit, "timeUnit");
        Assert.operation(this.variableExpiration, "Variable expiration is not enabled");
        return this.putInternal(key, value, expirationPolicy, TimeUnit.NANOSECONDS.convert(duration, timeUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Assert.notNull(map, "map");
        long expiration = this.expirationNanos.get();
        ExpirationPolicy expirationPolicy = this.expirationPolicy.get();
        this.writeLock.lock();
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.putInternal(entry.getKey(), entry.getValue(), expirationPolicy, expiration);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        Assert.notNull(key, "key");
        this.writeLock.lock();
        try {
            if (!this.entries.containsKey(key)) {
                V v = this.putInternal(key, value, this.expirationPolicy.get(), this.expirationNanos.get());
                return v;
            }
            Object v = ((ExpiringEntry)this.entries.get(key)).getValue();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Assert.notNull(key, "key");
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.remove(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            if (entry.cancel()) {
                this.scheduleEntry(this.entries.first());
            }
            Object v = entry.getValue();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        Assert.notNull(key, "key");
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            if (entry != null && entry.getValue().equals(value)) {
                this.entries.remove(key);
                if (entry.cancel()) {
                    this.scheduleEntry(this.entries.first());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        Assert.notNull(key, "key");
        this.writeLock.lock();
        try {
            if (this.entries.containsKey(key)) {
                V v = this.putInternal(key, value, this.expirationPolicy.get(), this.expirationNanos.get());
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Assert.notNull(key, "key");
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            if (entry != null && entry.getValue().equals(oldValue)) {
                this.putInternal(key, newValue, this.expirationPolicy.get(), this.expirationNanos.get());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeExpirationListener(ExpirationListener<K, V> listener) {
        Assert.notNull(listener, "listener");
        for (int i = 0; i < this.expirationListeners.size(); ++i) {
            if (!this.expirationListeners.get(i).equals(listener)) continue;
            this.expirationListeners.remove(i);
            return;
        }
    }

    public void removeAsyncExpirationListener(ExpirationListener<K, V> listener) {
        Assert.notNull(listener, "listener");
        for (int i = 0; i < this.asyncExpirationListeners.size(); ++i) {
            if (!this.asyncExpirationListeners.get(i).equals(listener)) continue;
            this.asyncExpirationListeners.remove(i);
            return;
        }
    }

    public void resetExpiration(K key) {
        Assert.notNull(key, "key");
        ExpiringEntry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            this.resetEntry(entry, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiration(K key, long duration, TimeUnit timeUnit) {
        Assert.notNull(key, "key");
        Assert.notNull(timeUnit, "timeUnit");
        Assert.operation(this.variableExpiration, "Variable expiration is not enabled");
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            if (entry != null) {
                entry.expirationNanos.set(TimeUnit.NANOSECONDS.convert(duration, timeUnit));
                this.resetEntry(entry, true);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setExpiration(long duration, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.operation(this.variableExpiration, "Variable expiration is not enabled");
        this.expirationNanos.set(TimeUnit.NANOSECONDS.convert(duration, timeUnit));
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        Assert.notNull(expirationPolicy, "expirationPolicy");
        this.expirationPolicy.set(expirationPolicy);
    }

    public void setExpirationPolicy(K key, ExpirationPolicy expirationPolicy) {
        Assert.notNull(key, "key");
        Assert.notNull(expirationPolicy, "expirationPolicy");
        Assert.operation(this.variableExpiration, "Variable expiration is not enabled");
        ExpiringEntry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            entry.expirationPolicy.set(expirationPolicy);
        }
    }

    public void setMaxSize(int maxSize) {
        Assert.operation(maxSize > 0, "maxSize");
        this.maxSize = maxSize;
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.entries.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object value) {
                return ExpiringMap.this.containsValue(value);
            }

            @Override
            public Iterator<V> iterator() {
                return ExpiringMap.this.entries instanceof EntryLinkedHashMap ? (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.ValueIterator() : (EntryTreeHashMap)ExpiringMap.this.entries.new EntryTreeHashMap.ValueIterator();
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    void notifyListeners(final ExpiringEntry<K, V> entry) {
        if (this.asyncExpirationListeners != null) {
            for (final ExpirationListener listener : this.asyncExpirationListeners) {
                LISTENER_SERVICE.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.expired(entry.key, entry.getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        if (this.expirationListeners != null) {
            for (final ExpirationListener listener : this.expirationListeners) {
                try {
                    listener.expired(entry.key, entry.getValue());
                }
                catch (Exception exception) {}
            }
        }
    }

    ExpiringEntry<K, V> getEntry(Object key) {
        this.readLock.lock();
        try {
            ExpiringEntry expiringEntry = (ExpiringEntry)this.entries.get(key);
            return expiringEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V putInternal(K key, V value, ExpirationPolicy expirationPolicy, long expirationNanos) {
        this.writeLock.lock();
        try {
            ExpiringEntry<K, V> entry = (ExpiringEntry<K, V>)this.entries.get(key);
            Object oldValue = null;
            if (entry == null) {
                entry = new ExpiringEntry<K, V>(key, value, this.variableExpiration ? new AtomicReference<ExpirationPolicy>(expirationPolicy) : this.expirationPolicy, this.variableExpiration ? new AtomicLong(expirationNanos) : this.expirationNanos);
                if (this.entries.size() >= this.maxSize) {
                    ExpiringEntry<K, V> expiredEntry = this.entries.first();
                    this.entries.remove(expiredEntry.key);
                    this.notifyListeners(expiredEntry);
                }
                this.entries.put(key, entry);
                if (this.entries.size() == 1 || this.entries.first().equals(entry)) {
                    this.scheduleEntry(entry);
                }
            } else {
                oldValue = entry.getValue();
                if (!ExpirationPolicy.ACCESSED.equals((Object)expirationPolicy) && (oldValue == null && value == null || oldValue != null && oldValue.equals(value))) {
                    V v = value;
                    return v;
                }
                entry.setValue(value);
                this.resetEntry(entry, false);
            }
            Object object = oldValue;
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEntry(ExpiringEntry<K, V> entry, boolean scheduleFirstEntry) {
        this.writeLock.lock();
        try {
            boolean scheduled = entry.cancel();
            this.entries.reorder(entry);
            if (scheduled || scheduleFirstEntry) {
                this.scheduleEntry(this.entries.first());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleEntry(ExpiringEntry<K, V> entry) {
        if (entry == null || entry.scheduled) {
            return;
        }
        Runnable runnable = null;
        ExpiringEntry<K, V> expiringEntry = entry;
        synchronized (expiringEntry) {
            if (entry.scheduled) {
                return;
            }
            final WeakReference<ExpiringEntry<K, V>> entryReference = new WeakReference<ExpiringEntry<K, V>>(entry);
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ExpiringEntry entry = (ExpiringEntry)entryReference.get();
                    ExpiringMap.this.writeLock.lock();
                    try {
                        if (entry != null && entry.scheduled) {
                            ExpiringMap.this.entries.remove(entry.key);
                            ExpiringMap.this.notifyListeners(entry);
                        }
                        try {
                            Iterator iterator = ExpiringMap.this.entries.valuesIterator();
                            boolean schedulePending = true;
                            while (iterator.hasNext() && schedulePending) {
                                ExpiringEntry nextEntry = iterator.next();
                                if (nextEntry.expectedExpiration.get() <= System.nanoTime()) {
                                    iterator.remove();
                                    ExpiringMap.this.notifyListeners(nextEntry);
                                    continue;
                                }
                                ExpiringMap.this.scheduleEntry(nextEntry);
                                schedulePending = false;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                    finally {
                        ExpiringMap.this.writeLock.unlock();
                    }
                }
            };
            ScheduledFuture<?> entryFuture = EXPIRER.schedule(runnable, entry.expectedExpiration.get() - System.nanoTime(), TimeUnit.NANOSECONDS);
            entry.schedule(entryFuture);
        }
    }

    private static <K, V> Map.Entry<K, V> mapEntryFor(final ExpiringEntry<K, V> entry) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return entry.key;
            }

            @Override
            public V getValue() {
                return entry.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class ExpiringEntry<K, V>
    implements Comparable<ExpiringEntry<K, V>> {
        final AtomicLong expirationNanos;
        final AtomicLong expectedExpiration;
        final AtomicReference<ExpirationPolicy> expirationPolicy;
        final K key;
        volatile Future<?> entryFuture;
        V value;
        volatile boolean scheduled;

        ExpiringEntry(K key, V value, AtomicReference<ExpirationPolicy> expirationPolicy, AtomicLong expirationNanos) {
            this.key = key;
            this.value = value;
            this.expirationPolicy = expirationPolicy;
            this.expirationNanos = expirationNanos;
            this.expectedExpiration = new AtomicLong();
            this.resetExpiration();
        }

        @Override
        public int compareTo(ExpiringEntry<K, V> other) {
            if (this.key.equals(other.key)) {
                return 0;
            }
            return this.expectedExpiration.get() < other.expectedExpiration.get() ? -1 : 1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiringEntry other = (ExpiringEntry)obj;
            if (!this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return this.value.toString();
        }

        synchronized boolean cancel() {
            boolean result = this.scheduled;
            if (this.entryFuture != null) {
                this.entryFuture.cancel(false);
            }
            this.entryFuture = null;
            this.scheduled = false;
            return result;
        }

        synchronized V getValue() {
            return this.value;
        }

        void resetExpiration() {
            this.expectedExpiration.set(this.expirationNanos.get() + System.nanoTime());
        }

        synchronized void schedule(Future<?> entryFuture) {
            this.entryFuture = entryFuture;
            this.scheduled = true;
        }

        synchronized void setValue(V value) {
            this.value = value;
        }
    }

    private static class EntryTreeHashMap<K, V>
    extends HashMap<K, ExpiringEntry<K, V>>
    implements EntryMap<K, V> {
        private static final long serialVersionUID = 1L;
        SortedSet<ExpiringEntry<K, V>> sortedSet = new TreeSet<ExpiringEntry<K, V>>();

        private EntryTreeHashMap() {
        }

        @Override
        public void clear() {
            super.clear();
            this.sortedSet.clear();
        }

        @Override
        public boolean containsValue(Object value) {
            for (ExpiringEntry entry : this.values()) {
                Object v = entry.value;
                if (v != value && (value == null || !value.equals(v))) continue;
                return true;
            }
            return false;
        }

        @Override
        public ExpiringEntry<K, V> first() {
            return this.sortedSet.isEmpty() ? null : this.sortedSet.first();
        }

        @Override
        public ExpiringEntry<K, V> put(K key, ExpiringEntry<K, V> value) {
            this.sortedSet.add(value);
            return super.put(key, value);
        }

        @Override
        public ExpiringEntry<K, V> remove(Object key) {
            ExpiringEntry entry = (ExpiringEntry)super.remove(key);
            if (entry != null) {
                this.sortedSet.remove(entry);
            }
            return entry;
        }

        @Override
        public void reorder(ExpiringEntry<K, V> value) {
            this.sortedSet.remove(value);
            value.resetExpiration();
            this.sortedSet.add(value);
        }

        @Override
        public Iterator<ExpiringEntry<K, V>> valuesIterator() {
            return new ExpiringEntryIterator();
        }

        final class EntryIterator
        extends AbstractHashIterator
        implements Iterator<Map.Entry<K, V>> {
            EntryIterator() {
            }

            @Override
            public final Map.Entry<K, V> next() {
                return ExpiringMap.mapEntryFor(this.getNext());
            }
        }

        final class ValueIterator
        extends AbstractHashIterator
        implements Iterator<V> {
            ValueIterator() {
            }

            @Override
            public final V next() {
                return this.getNext().value;
            }
        }

        final class KeyIterator
        extends AbstractHashIterator
        implements Iterator<K> {
            KeyIterator() {
            }

            @Override
            public final K next() {
                return this.getNext().key;
            }
        }

        final class ExpiringEntryIterator
        extends AbstractHashIterator
        implements Iterator<ExpiringEntry<K, V>> {
            ExpiringEntryIterator() {
            }

            @Override
            public final ExpiringEntry<K, V> next() {
                return this.getNext();
            }
        }

        abstract class AbstractHashIterator {
            private final Iterator<ExpiringEntry<K, V>> iterator;
            protected ExpiringEntry<K, V> next;

            AbstractHashIterator() {
                this.iterator = EntryTreeHashMap.this.sortedSet.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public ExpiringEntry<K, V> getNext() {
                this.next = this.iterator.next();
                return this.next;
            }

            public void remove() {
                EntryTreeHashMap.super.remove(this.next.key);
                this.iterator.remove();
            }
        }
    }

    private static class EntryLinkedHashMap<K, V>
    extends LinkedHashMap<K, ExpiringEntry<K, V>>
    implements EntryMap<K, V> {
        private static final long serialVersionUID = 1L;

        private EntryLinkedHashMap() {
        }

        @Override
        public boolean containsValue(Object value) {
            for (ExpiringEntry entry : this.values()) {
                Object v = entry.value;
                if (v != value && (value == null || !value.equals(v))) continue;
                return true;
            }
            return false;
        }

        @Override
        public ExpiringEntry<K, V> first() {
            return this.isEmpty() ? null : (ExpiringEntry)this.values().iterator().next();
        }

        @Override
        public void reorder(ExpiringEntry<K, V> value) {
            this.remove(value.key);
            value.resetExpiration();
            this.put(value.key, value);
        }

        @Override
        public Iterator<ExpiringEntry<K, V>> valuesIterator() {
            return this.values().iterator();
        }

        public final class EntryIterator
        extends AbstractHashIterator
        implements Iterator<Map.Entry<K, V>> {
            @Override
            public final Map.Entry<K, V> next() {
                return ExpiringMap.mapEntryFor(this.getNext());
            }
        }

        final class ValueIterator
        extends AbstractHashIterator
        implements Iterator<V> {
            ValueIterator() {
            }

            @Override
            public final V next() {
                return this.getNext().value;
            }
        }

        final class KeyIterator
        extends AbstractHashIterator
        implements Iterator<K> {
            KeyIterator() {
            }

            @Override
            public final K next() {
                return this.getNext().key;
            }
        }

        abstract class AbstractHashIterator {
            private final Iterator<Map.Entry<K, ExpiringEntry<K, V>>> iterator;
            private ExpiringEntry<K, V> next;

            AbstractHashIterator() {
                this.iterator = EntryLinkedHashMap.this.entrySet().iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public ExpiringEntry<K, V> getNext() {
                this.next = this.iterator.next().getValue();
                return this.next;
            }

            public void remove() {
                this.iterator.remove();
            }
        }
    }

    private static interface EntryMap<K, V>
    extends Map<K, ExpiringEntry<K, V>> {
        public ExpiringEntry<K, V> first();

        public void reorder(ExpiringEntry<K, V> var1);

        public Iterator<ExpiringEntry<K, V>> valuesIterator();
    }

    public static final class Builder<K, V> {
        private ExpirationPolicy expirationPolicy = ExpirationPolicy.CREATED;
        private List<ExpirationListener<K, V>> expirationListeners;
        private List<ExpirationListener<K, V>> asyncExpirationListeners;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private boolean variableExpiration;
        private long duration = 60L;
        private int maxSize = Integer.MAX_VALUE;
        private EntryLoader<K, V> entryLoader;
        private ExpiringEntryLoader<K, V> expiringEntryLoader;

        private Builder() {
        }

        public <K1 extends K, V1 extends V> ExpiringMap<K1, V1> build() {
            return new ExpiringMap(this);
        }

        public Builder<K, V> expiration(long duration, TimeUnit timeUnit) {
            this.duration = duration;
            this.timeUnit = Assert.notNull(timeUnit, "timeUnit");
            return this;
        }

        public Builder<K, V> maxSize(int maxSize) {
            Assert.operation(maxSize > 0, "maxSize");
            this.maxSize = maxSize;
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> entryLoader(EntryLoader<? super K1, ? super V1> loader) {
            this.assertNoLoaderSet();
            this.entryLoader = Assert.notNull(loader, "loader");
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> expiringEntryLoader(ExpiringEntryLoader<? super K1, ? super V1> loader) {
            this.assertNoLoaderSet();
            this.expiringEntryLoader = Assert.notNull(loader, "loader");
            this.variableExpiration();
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> expirationListener(ExpirationListener<? super K1, ? super V1> listener) {
            Assert.notNull(listener, "listener");
            if (this.expirationListeners == null) {
                this.expirationListeners = new ArrayList<ExpirationListener<K, V>>();
            }
            this.expirationListeners.add(listener);
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> expirationListeners(List<ExpirationListener<? super K1, ? super V1>> listeners) {
            Assert.notNull(listeners, "listeners");
            if (this.expirationListeners == null) {
                this.expirationListeners = new ArrayList<ExpirationListener<K, V>>(listeners.size());
            }
            for (ExpirationListener<K1, V1> expirationListener : listeners) {
                this.expirationListeners.add(expirationListener);
            }
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> asyncExpirationListener(ExpirationListener<? super K1, ? super V1> listener) {
            Assert.notNull(listener, "listener");
            if (this.asyncExpirationListeners == null) {
                this.asyncExpirationListeners = new ArrayList<ExpirationListener<K, V>>();
            }
            this.asyncExpirationListeners.add(listener);
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> asyncExpirationListeners(List<ExpirationListener<? super K1, ? super V1>> listeners) {
            Assert.notNull(listeners, "listeners");
            if (this.asyncExpirationListeners == null) {
                this.asyncExpirationListeners = new ArrayList<ExpirationListener<K, V>>(listeners.size());
            }
            for (ExpirationListener<K1, V1> expirationListener : listeners) {
                this.asyncExpirationListeners.add(expirationListener);
            }
            return this;
        }

        public Builder<K, V> expirationPolicy(ExpirationPolicy expirationPolicy) {
            this.expirationPolicy = Assert.notNull(expirationPolicy, "expirationPolicy");
            return this;
        }

        public Builder<K, V> variableExpiration() {
            this.variableExpiration = true;
            return this;
        }

        private void assertNoLoaderSet() {
            Assert.state(this.entryLoader == null && this.expiringEntryLoader == null, "Either entryLoader or expiringEntryLoader may be set, not both", new Object[0]);
        }
    }
}

