/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.properties.types;

import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.file.FileConfiguration;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyType;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import io.lumine.xikage.mythicmobs.utils.serialize.BlockLocus;

public class BlockLocProp
extends PropertyType<BlockLocus> {
    private final BlockLocus def;

    public BlockLocProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.def = BlockLocus.of(0, 0, 0);
    }

    public BlockLocProp(LuminePlugin plugin, Object file, String node, BlockLocus def) {
        super(plugin, file, node);
        this.def = def;
    }

    @Override
    protected BlockLocus compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        String prop = section.getString(node);
        if (prop == null) {
            return this.def;
        }
        try {
            String[] split = prop.split(",");
            int x = Integer.valueOf(split[0]);
            int y = Integer.valueOf(split[1]);
            int z = Integer.valueOf(split[2]);
            return BlockLocus.of(x, y, z);
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void set(String holder, BlockLocus value) {
        if (this.config == null) {
            return;
        }
        String val = value.getX() + "," + value.getY() + "," + value.getZ();
        if (holder != null) {
            this.config.set(holder + "." + this.node, val);
        } else {
            this.config.set(this.node, val);
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }
}

