/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.menu;

import io.lumine.xikage.mythicmobs.utils.config.properties.types.MenuProp;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.menu.EditableMenuBuilder;
import io.lumine.xikage.mythicmobs.utils.menu.Menu;
import io.lumine.xikage.mythicmobs.utils.menu.MenuData;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class ReloadableMenu<T> {
    private final MenuProp<T> menuProperty;
    private EditableMenuBuilder<T> builder;
    private Menu<T> menu;
    private boolean buildOnOpen;

    public ReloadableMenu(MenuProp<T> menu) {
        this(menu, false);
    }

    public ReloadableMenu(MenuProp<T> menu, boolean buildOnOpen) {
        this.menuProperty = menu;
        this.buildOnOpen = buildOnOpen;
    }

    public void reload() {
        this.builder = (EditableMenuBuilder)this.menuProperty.get();
        this.menu = this.build(this.builder).build();
    }

    public abstract EditableMenuBuilder<T> build(EditableMenuBuilder<T> var1);

    public void open(Player player, T state) {
        if (this.buildOnOpen) {
            this.build(this.builder).build().open(player, state);
        } else {
            this.menu.open(player, state);
        }
    }

    public void open(Player player, T state, List<MenuData<T>> data) {
        Log.info("Data Points: {0}", data.size());
        if (this.buildOnOpen) {
            this.build(this.builder).build().open(player, state, data);
        } else {
            this.menu.open(player, state, data);
        }
    }

    public void nextPage(Player player) {
        this.menu.nextPage(player);
    }

    public void previousPage(Player player) {
        this.menu.previousPage(player);
    }
}

